/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTMapBufferRange {
    public static final int GL_MAP_READ_BIT_EXT = 1;
    public static final int GL_MAP_WRITE_BIT_EXT = 2;
    public static final int GL_MAP_INVALIDATE_RANGE_BIT_EXT = 4;
    public static final int GL_MAP_INVALIDATE_BUFFER_BIT_EXT = 8;
    public static final int GL_MAP_FLUSH_EXPLICIT_BIT_EXT = 16;
    public static final int GL_MAP_UNSYNCHRONIZED_BIT_EXT = 32;

    protected EXTMapBufferRange() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glMapBufferRangeEXT, caps.glFlushMappedBufferRangeEXT);
    }

    public static long nglMapBufferRangeEXT(int target, long offset, long length, int access) {
        long __functionAddress = GLES.getCapabilities().glMapBufferRangeEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPPP(__functionAddress, target, offset, length, access);
    }

    public static ByteBuffer glMapBufferRangeEXT(int target, long offset, long length, int access) {
        long __result = EXTMapBufferRange.nglMapBufferRangeEXT(target, offset, length, access);
        return MemoryUtil.memByteBuffer(__result, (int)length);
    }

    public static ByteBuffer glMapBufferRangeEXT(int target, long offset, long length, int access, ByteBuffer old_buffer) {
        long __result = EXTMapBufferRange.nglMapBufferRangeEXT(target, offset, length, access);
        return old_buffer == null ? MemoryUtil.memByteBuffer(__result, (int)length) : MemoryUtil.memSetupBuffer(old_buffer, __result, (int)length);
    }

    public static void glFlushMappedBufferRangeEXT(int target, long offset, long length) {
        long __functionAddress = GLES.getCapabilities().glFlushMappedBufferRangeEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, target, offset, length);
    }
}

