/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class AMDPerformanceMonitor {
    public static final int GL_COUNTER_TYPE_AMD = 35776;
    public static final int GL_COUNTER_RANGE_AMD = 35777;
    public static final int GL_UNSIGNED_INT64_AMD = 35778;
    public static final int GL_PERCENTAGE_AMD = 35779;
    public static final int GL_PERFMON_RESULT_AVAILABLE_AMD = 35780;
    public static final int GL_PERFMON_RESULT_SIZE_AMD = 35781;
    public static final int GL_PERFMON_RESULT_AMD = 35782;

    protected AMDPerformanceMonitor() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glGetPerfMonitorGroupsAMD, caps.glGetPerfMonitorCountersAMD, caps.glGetPerfMonitorGroupStringAMD, caps.glGetPerfMonitorCounterStringAMD, caps.glGetPerfMonitorCounterInfoAMD, caps.glGenPerfMonitorsAMD, caps.glDeletePerfMonitorsAMD, caps.glSelectPerfMonitorCountersAMD, caps.glBeginPerfMonitorAMD, caps.glEndPerfMonitorAMD, caps.glGetPerfMonitorCounterDataAMD);
    }

    public static void nglGetPerfMonitorGroupsAMD(long numGroups, int groupsSize, long groups) {
        long __functionAddress = GLES.getCapabilities().glGetPerfMonitorGroupsAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, numGroups, groupsSize, groups);
    }

    public static void glGetPerfMonitorGroupsAMD(IntBuffer numGroups, IntBuffer groups) {
        if (Checks.CHECKS && numGroups != null) {
            Checks.checkBuffer((Buffer)numGroups, 1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorGroupsAMD(MemoryUtil.memAddressSafe(numGroups), groups == null ? 0 : groups.remaining(), MemoryUtil.memAddressSafe(groups));
    }

    public static void nglGetPerfMonitorCountersAMD(int group, long numCounters, long maxActiveCounters, int counterSize, long counters) {
        long __functionAddress = GLES.getCapabilities().glGetPerfMonitorCountersAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, group, numCounters, maxActiveCounters, counterSize, counters);
    }

    public static void glGetPerfMonitorCountersAMD(int group, IntBuffer numCounters, IntBuffer maxActiveCounters, IntBuffer counters) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)numCounters, 1);
            Checks.checkBuffer((Buffer)maxActiveCounters, 1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCountersAMD(group, MemoryUtil.memAddress(numCounters), MemoryUtil.memAddress(maxActiveCounters), counters.remaining(), MemoryUtil.memAddress(counters));
    }

    public static void nglGetPerfMonitorGroupStringAMD(int group, int bufSize, long length, long groupString) {
        long __functionAddress = GLES.getCapabilities().glGetPerfMonitorGroupStringAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, group, bufSize, length, groupString);
    }

    public static void glGetPerfMonitorGroupStringAMD(int group, IntBuffer length, ByteBuffer groupString) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorGroupStringAMD(group, groupString.remaining(), MemoryUtil.memAddress(length), MemoryUtil.memAddress(groupString));
    }

    public static void nglGetPerfMonitorCounterStringAMD(int group, int counter, int bufSize, long length, long counterString) {
        long __functionAddress = GLES.getCapabilities().glGetPerfMonitorCounterStringAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, group, counter, bufSize, length, counterString);
    }

    public static void glGetPerfMonitorCounterStringAMD(int group, int counter, IntBuffer length, ByteBuffer counterString) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterStringAMD(group, counter, counterString == null ? 0 : counterString.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddressSafe(counterString));
    }

    public static void nglGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, long data) {
        long __functionAddress = GLES.getCapabilities().glGetPerfMonitorCounterInfoAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, group, counter, pname, data);
    }

    public static void glGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 4);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterInfoAMD(group, counter, pname, MemoryUtil.memAddress(data));
    }

    public static void glGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterInfoAMD(group, counter, pname, MemoryUtil.memAddress(data));
    }

    public static void glGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterInfoAMD(group, counter, pname, MemoryUtil.memAddress(data));
    }

    public static void nglGenPerfMonitorsAMD(int n, long monitors) {
        long __functionAddress = GLES.getCapabilities().glGenPerfMonitorsAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, n, monitors);
    }

    public static void glGenPerfMonitorsAMD(IntBuffer monitors) {
        AMDPerformanceMonitor.nglGenPerfMonitorsAMD(monitors.remaining(), MemoryUtil.memAddress(monitors));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenPerfMonitorsAMD() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer monitors = stack.callocInt(1);
            AMDPerformanceMonitor.nglGenPerfMonitorsAMD(1, MemoryUtil.memAddress(monitors));
            int n = monitors.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDeletePerfMonitorsAMD(int n, long monitors) {
        long __functionAddress = GLES.getCapabilities().glDeletePerfMonitorsAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, n, monitors);
    }

    public static void glDeletePerfMonitorsAMD(IntBuffer monitors) {
        AMDPerformanceMonitor.nglDeletePerfMonitorsAMD(monitors.remaining(), MemoryUtil.memAddress(monitors));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeletePerfMonitorsAMD(int monitor) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer monitors = stack.ints(monitor);
            AMDPerformanceMonitor.nglDeletePerfMonitorsAMD(1, MemoryUtil.memAddress(monitors));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglSelectPerfMonitorCountersAMD(int monitor, boolean enable, int group, int numCounters, long counterList) {
        long __functionAddress = GLES.getCapabilities().glSelectPerfMonitorCountersAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, monitor, enable, group, numCounters, counterList);
    }

    public static void glSelectPerfMonitorCountersAMD(int monitor, boolean enable, int group, IntBuffer counterList) {
        AMDPerformanceMonitor.nglSelectPerfMonitorCountersAMD(monitor, enable, group, counterList.remaining(), MemoryUtil.memAddress(counterList));
    }

    public static void glBeginPerfMonitorAMD(int monitor) {
        long __functionAddress = GLES.getCapabilities().glBeginPerfMonitorAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, monitor);
    }

    public static void glEndPerfMonitorAMD(int monitor) {
        long __functionAddress = GLES.getCapabilities().glEndPerfMonitorAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, monitor);
    }

    public static void nglGetPerfMonitorCounterDataAMD(int monitor, int pname, int dataSize, long data, long bytesWritten) {
        long __functionAddress = GLES.getCapabilities().glGetPerfMonitorCounterDataAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, monitor, pname, dataSize, data, bytesWritten);
    }

    public static void glGetPerfMonitorCounterDataAMD(int monitor, int pname, IntBuffer data, IntBuffer bytesWritten) {
        if (Checks.CHECKS && bytesWritten != null) {
            Checks.checkBuffer((Buffer)bytesWritten, 1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterDataAMD(monitor, pname, data.remaining(), MemoryUtil.memAddress(data), MemoryUtil.memAddressSafe(bytesWritten));
    }

    public static void glGetPerfMonitorGroupsAMD(int[] numGroups, int[] groups) {
        long __functionAddress = GLES.getCapabilities().glGetPerfMonitorGroupsAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (numGroups != null) {
                Checks.checkBuffer(numGroups, 1);
            }
        }
        JNI.callPPV(__functionAddress, numGroups, groups == null ? 0 : groups.length, groups);
    }

    public static void glGetPerfMonitorCountersAMD(int group, int[] numCounters, int[] maxActiveCounters, int[] counters) {
        long __functionAddress = GLES.getCapabilities().glGetPerfMonitorCountersAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(numCounters, 1);
            Checks.checkBuffer(maxActiveCounters, 1);
        }
        JNI.callPPPV(__functionAddress, group, numCounters, maxActiveCounters, counters.length, counters);
    }

    public static void glGetPerfMonitorGroupStringAMD(int group, int[] length, ByteBuffer groupString) {
        long __functionAddress = GLES.getCapabilities().glGetPerfMonitorGroupStringAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(length, 1);
        }
        JNI.callPPV(__functionAddress, group, groupString.remaining(), length, MemoryUtil.memAddress(groupString));
    }

    public static void glGetPerfMonitorCounterStringAMD(int group, int counter, int[] length, ByteBuffer counterString) {
        long __functionAddress = GLES.getCapabilities().glGetPerfMonitorCounterStringAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (length != null) {
                Checks.checkBuffer(length, 1);
            }
        }
        JNI.callPPV(__functionAddress, group, counter, counterString == null ? 0 : counterString.remaining(), length, MemoryUtil.memAddressSafe(counterString));
    }

    public static void glGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, int[] data) {
        long __functionAddress = GLES.getCapabilities().glGetPerfMonitorCounterInfoAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(data, 4);
        }
        JNI.callPV(__functionAddress, group, counter, pname, data);
    }

    public static void glGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, float[] data) {
        long __functionAddress = GLES.getCapabilities().glGetPerfMonitorCounterInfoAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(data, 4);
        }
        JNI.callPV(__functionAddress, group, counter, pname, data);
    }

    public static void glGenPerfMonitorsAMD(int[] monitors) {
        long __functionAddress = GLES.getCapabilities().glGenPerfMonitorsAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, monitors.length, monitors);
    }

    public static void glDeletePerfMonitorsAMD(int[] monitors) {
        long __functionAddress = GLES.getCapabilities().glDeletePerfMonitorsAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, monitors.length, monitors);
    }

    public static void glSelectPerfMonitorCountersAMD(int monitor, boolean enable, int group, int[] counterList) {
        long __functionAddress = GLES.getCapabilities().glSelectPerfMonitorCountersAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, monitor, enable, group, counterList.length, counterList);
    }

    public static void glGetPerfMonitorCounterDataAMD(int monitor, int pname, int[] data, int[] bytesWritten) {
        long __functionAddress = GLES.getCapabilities().glGetPerfMonitorCounterDataAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (bytesWritten != null) {
                Checks.checkBuffer(bytesWritten, 1);
            }
        }
        JNI.callPPV(__functionAddress, monitor, pname, data.length, data, bytesWritten);
    }
}

