/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GL33 {
    public static final int GL_SRC1_COLOR = 35065;
    public static final int GL_ONE_MINUS_SRC1_COLOR = 35066;
    public static final int GL_ONE_MINUS_SRC1_ALPHA = 35067;
    public static final int GL_MAX_DUAL_SOURCE_DRAW_BUFFERS = 35068;
    public static final int GL_ANY_SAMPLES_PASSED = 35887;
    public static final int GL_SAMPLER_BINDING = 35097;
    public static final int GL_RGB10_A2UI = 36975;
    public static final int GL_TEXTURE_SWIZZLE_R = 36418;
    public static final int GL_TEXTURE_SWIZZLE_G = 36419;
    public static final int GL_TEXTURE_SWIZZLE_B = 36420;
    public static final int GL_TEXTURE_SWIZZLE_A = 36421;
    public static final int GL_TEXTURE_SWIZZLE_RGBA = 36422;
    public static final int GL_TIME_ELAPSED = 35007;
    public static final int GL_TIMESTAMP = 36392;
    public static final int GL_VERTEX_ATTRIB_ARRAY_DIVISOR = 35070;
    public static final int GL_INT_2_10_10_10_REV = 36255;

    protected GL33() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps, boolean fc) {
        return (fc || Checks.checkFunctions(caps.glVertexP2ui, caps.glVertexP3ui, caps.glVertexP4ui, caps.glVertexP2uiv, caps.glVertexP3uiv, caps.glVertexP4uiv, caps.glTexCoordP1ui, caps.glTexCoordP2ui, caps.glTexCoordP3ui, caps.glTexCoordP4ui, caps.glTexCoordP1uiv, caps.glTexCoordP2uiv, caps.glTexCoordP3uiv, caps.glTexCoordP4uiv, caps.glMultiTexCoordP1ui, caps.glMultiTexCoordP2ui, caps.glMultiTexCoordP3ui, caps.glMultiTexCoordP4ui, caps.glMultiTexCoordP1uiv, caps.glMultiTexCoordP2uiv, caps.glMultiTexCoordP3uiv, caps.glMultiTexCoordP4uiv, caps.glNormalP3ui, caps.glNormalP3uiv, caps.glColorP3ui, caps.glColorP4ui, caps.glColorP3uiv, caps.glColorP4uiv, caps.glSecondaryColorP3ui, caps.glSecondaryColorP3uiv)) && Checks.checkFunctions(caps.glBindFragDataLocationIndexed, caps.glGetFragDataIndex, caps.glGenSamplers, caps.glDeleteSamplers, caps.glIsSampler, caps.glBindSampler, caps.glSamplerParameteri, caps.glSamplerParameterf, caps.glSamplerParameteriv, caps.glSamplerParameterfv, caps.glSamplerParameterIiv, caps.glSamplerParameterIuiv, caps.glGetSamplerParameteriv, caps.glGetSamplerParameterfv, caps.glGetSamplerParameterIiv, caps.glGetSamplerParameterIuiv, caps.glQueryCounter, caps.glGetQueryObjecti64v, caps.glGetQueryObjectui64v, caps.glVertexAttribDivisor, caps.glVertexAttribP1ui, caps.glVertexAttribP2ui, caps.glVertexAttribP3ui, caps.glVertexAttribP4ui, caps.glVertexAttribP1uiv, caps.glVertexAttribP2uiv, caps.glVertexAttribP3uiv, caps.glVertexAttribP4uiv);
    }

    public static void nglBindFragDataLocationIndexed(int program, int colorNumber, int index, long name) {
        long __functionAddress = GL.getCapabilities().glBindFragDataLocationIndexed;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, colorNumber, index, name);
    }

    public static void glBindFragDataLocationIndexed(int program, int colorNumber, int index, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        GL33.nglBindFragDataLocationIndexed(program, colorNumber, index, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glBindFragDataLocationIndexed(int program, int colorNumber, int index, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            GL33.nglBindFragDataLocationIndexed(program, colorNumber, index, MemoryUtil.memAddress(nameEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nglGetFragDataIndex(int program, long name) {
        long __functionAddress = GL.getCapabilities().glGetFragDataIndex;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPI(__functionAddress, program, name);
    }

    public static int glGetFragDataIndex(int program, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return GL33.nglGetFragDataIndex(program, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetFragDataIndex(int program, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = GL33.nglGetFragDataIndex(program, MemoryUtil.memAddress(nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGenSamplers(int count, long samplers) {
        long __functionAddress = GL.getCapabilities().glGenSamplers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, count, samplers);
    }

    public static void glGenSamplers(IntBuffer samplers) {
        GL33.nglGenSamplers(samplers.remaining(), MemoryUtil.memAddress(samplers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenSamplers() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer samplers = stack.callocInt(1);
            GL33.nglGenSamplers(1, MemoryUtil.memAddress(samplers));
            int n = samplers.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDeleteSamplers(int count, long samplers) {
        long __functionAddress = GL.getCapabilities().glDeleteSamplers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, count, samplers);
    }

    public static void glDeleteSamplers(IntBuffer samplers) {
        GL33.nglDeleteSamplers(samplers.remaining(), MemoryUtil.memAddress(samplers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteSamplers(int sampler) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer samplers = stack.ints(sampler);
            GL33.nglDeleteSamplers(1, MemoryUtil.memAddress(samplers));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean glIsSampler(int sampler) {
        long __functionAddress = GL.getCapabilities().glIsSampler;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callZ(__functionAddress, sampler);
    }

    public static void glBindSampler(int unit, int sampler) {
        long __functionAddress = GL.getCapabilities().glBindSampler;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, unit, sampler);
    }

    public static void glSamplerParameteri(int sampler, int pname, int param) {
        long __functionAddress = GL.getCapabilities().glSamplerParameteri;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, sampler, pname, param);
    }

    public static void glSamplerParameterf(int sampler, int pname, float param) {
        long __functionAddress = GL.getCapabilities().glSamplerParameterf;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, sampler, pname, param);
    }

    public static void nglSamplerParameteriv(int sampler, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glSamplerParameteriv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameteriv(int sampler, int pname, IntBuffer params) {
        GL33.nglSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void nglSamplerParameterfv(int sampler, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glSamplerParameterfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterfv(int sampler, int pname, FloatBuffer params) {
        GL33.nglSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void nglSamplerParameterIiv(int sampler, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glSamplerParameterIiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterIiv(int sampler, int pname, IntBuffer params) {
        GL33.nglSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void nglSamplerParameterIuiv(int sampler, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glSamplerParameterIuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterIuiv(int sampler, int pname, IntBuffer params) {
        GL33.nglSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void nglGetSamplerParameteriv(int sampler, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetSamplerParameteriv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameteriv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL33.nglGetSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetSamplerParameteri(int sampler, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL33.nglGetSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetSamplerParameterfv(int sampler, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetSamplerParameterfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterfv(int sampler, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL33.nglGetSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetSamplerParameterf(int sampler, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            GL33.nglGetSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetSamplerParameterIiv(int sampler, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetSamplerParameterIiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterIiv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL33.nglGetSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetSamplerParameterIi(int sampler, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL33.nglGetSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetSamplerParameterIuiv(int sampler, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetSamplerParameterIuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterIuiv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL33.nglGetSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetSamplerParameterIui(int sampler, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL33.nglGetSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glQueryCounter(int id, int target) {
        long __functionAddress = GL.getCapabilities().glQueryCounter;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, id, target);
    }

    public static void nglGetQueryObjecti64v(int id, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetQueryObjecti64v;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, id, pname, params);
    }

    public static void glGetQueryObjecti64v(int id, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL33.nglGetQueryObjecti64v(id, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetQueryObjecti64(int id, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            GL33.nglGetQueryObjecti64v(id, pname, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetQueryObjectui64v(int id, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetQueryObjectui64v;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, id, pname, params);
    }

    public static void glGetQueryObjectui64v(int id, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL33.nglGetQueryObjectui64v(id, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetQueryObjectui64(int id, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            GL33.nglGetQueryObjectui64v(id, pname, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glVertexAttribDivisor(int index, int divisor) {
        long __functionAddress = GL.getCapabilities().glVertexAttribDivisor;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, divisor);
    }

    public static void glVertexP2ui(int type, int value) {
        long __functionAddress = GL.getCapabilities().glVertexP2ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, type, value);
    }

    public static void glVertexP3ui(int type, int value) {
        long __functionAddress = GL.getCapabilities().glVertexP3ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, type, value);
    }

    public static void glVertexP4ui(int type, int value) {
        long __functionAddress = GL.getCapabilities().glVertexP4ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, type, value);
    }

    public static void nglVertexP2uiv(int type, long value) {
        long __functionAddress = GL.getCapabilities().glVertexP2uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, type, value);
    }

    public static void glVertexP2uiv(int type, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        GL33.nglVertexP2uiv(type, MemoryUtil.memAddress(value));
    }

    public static void nglVertexP3uiv(int type, long value) {
        long __functionAddress = GL.getCapabilities().glVertexP3uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, type, value);
    }

    public static void glVertexP3uiv(int type, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        GL33.nglVertexP3uiv(type, MemoryUtil.memAddress(value));
    }

    public static void nglVertexP4uiv(int type, long value) {
        long __functionAddress = GL.getCapabilities().glVertexP4uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, type, value);
    }

    public static void glVertexP4uiv(int type, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        GL33.nglVertexP4uiv(type, MemoryUtil.memAddress(value));
    }

    public static void glTexCoordP1ui(int type, int coords) {
        long __functionAddress = GL.getCapabilities().glTexCoordP1ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, type, coords);
    }

    public static void glTexCoordP2ui(int type, int coords) {
        long __functionAddress = GL.getCapabilities().glTexCoordP2ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, type, coords);
    }

    public static void glTexCoordP3ui(int type, int coords) {
        long __functionAddress = GL.getCapabilities().glTexCoordP3ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, type, coords);
    }

    public static void glTexCoordP4ui(int type, int coords) {
        long __functionAddress = GL.getCapabilities().glTexCoordP4ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, type, coords);
    }

    public static void nglTexCoordP1uiv(int type, long coords) {
        long __functionAddress = GL.getCapabilities().glTexCoordP1uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, type, coords);
    }

    public static void glTexCoordP1uiv(int type, IntBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, 1);
        }
        GL33.nglTexCoordP1uiv(type, MemoryUtil.memAddress(coords));
    }

    public static void nglTexCoordP2uiv(int type, long coords) {
        long __functionAddress = GL.getCapabilities().glTexCoordP2uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, type, coords);
    }

    public static void glTexCoordP2uiv(int type, IntBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, 1);
        }
        GL33.nglTexCoordP2uiv(type, MemoryUtil.memAddress(coords));
    }

    public static void nglTexCoordP3uiv(int type, long coords) {
        long __functionAddress = GL.getCapabilities().glTexCoordP3uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, type, coords);
    }

    public static void glTexCoordP3uiv(int type, IntBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, 1);
        }
        GL33.nglTexCoordP3uiv(type, MemoryUtil.memAddress(coords));
    }

    public static void nglTexCoordP4uiv(int type, long coords) {
        long __functionAddress = GL.getCapabilities().glTexCoordP4uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, type, coords);
    }

    public static void glTexCoordP4uiv(int type, IntBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, 1);
        }
        GL33.nglTexCoordP4uiv(type, MemoryUtil.memAddress(coords));
    }

    public static void glMultiTexCoordP1ui(int texture, int type, int coords) {
        long __functionAddress = GL.getCapabilities().glMultiTexCoordP1ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texture, type, coords);
    }

    public static void glMultiTexCoordP2ui(int texture, int type, int coords) {
        long __functionAddress = GL.getCapabilities().glMultiTexCoordP2ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texture, type, coords);
    }

    public static void glMultiTexCoordP3ui(int texture, int type, int coords) {
        long __functionAddress = GL.getCapabilities().glMultiTexCoordP3ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texture, type, coords);
    }

    public static void glMultiTexCoordP4ui(int texture, int type, int coords) {
        long __functionAddress = GL.getCapabilities().glMultiTexCoordP4ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texture, type, coords);
    }

    public static void nglMultiTexCoordP1uiv(int texture, int type, long coords) {
        long __functionAddress = GL.getCapabilities().glMultiTexCoordP1uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, type, coords);
    }

    public static void glMultiTexCoordP1uiv(int texture, int type, IntBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, 1);
        }
        GL33.nglMultiTexCoordP1uiv(texture, type, MemoryUtil.memAddress(coords));
    }

    public static void nglMultiTexCoordP2uiv(int texture, int type, long coords) {
        long __functionAddress = GL.getCapabilities().glMultiTexCoordP2uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, type, coords);
    }

    public static void glMultiTexCoordP2uiv(int texture, int type, IntBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, 1);
        }
        GL33.nglMultiTexCoordP2uiv(texture, type, MemoryUtil.memAddress(coords));
    }

    public static void nglMultiTexCoordP3uiv(int texture, int type, long coords) {
        long __functionAddress = GL.getCapabilities().glMultiTexCoordP3uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, type, coords);
    }

    public static void glMultiTexCoordP3uiv(int texture, int type, IntBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, 1);
        }
        GL33.nglMultiTexCoordP3uiv(texture, type, MemoryUtil.memAddress(coords));
    }

    public static void nglMultiTexCoordP4uiv(int texture, int type, long coords) {
        long __functionAddress = GL.getCapabilities().glMultiTexCoordP4uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, type, coords);
    }

    public static void glMultiTexCoordP4uiv(int texture, int type, IntBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, 1);
        }
        GL33.nglMultiTexCoordP4uiv(texture, type, MemoryUtil.memAddress(coords));
    }

    public static void glNormalP3ui(int type, int coords) {
        long __functionAddress = GL.getCapabilities().glNormalP3ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, type, coords);
    }

    public static void nglNormalP3uiv(int type, long coords) {
        long __functionAddress = GL.getCapabilities().glNormalP3uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, type, coords);
    }

    public static void glNormalP3uiv(int type, IntBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, 1);
        }
        GL33.nglNormalP3uiv(type, MemoryUtil.memAddress(coords));
    }

    public static void glColorP3ui(int type, int color) {
        long __functionAddress = GL.getCapabilities().glColorP3ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, type, color);
    }

    public static void glColorP4ui(int type, int color) {
        long __functionAddress = GL.getCapabilities().glColorP4ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, type, color);
    }

    public static void nglColorP3uiv(int type, long color) {
        long __functionAddress = GL.getCapabilities().glColorP3uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, type, color);
    }

    public static void glColorP3uiv(int type, IntBuffer color) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)color, 1);
        }
        GL33.nglColorP3uiv(type, MemoryUtil.memAddress(color));
    }

    public static void nglColorP4uiv(int type, long color) {
        long __functionAddress = GL.getCapabilities().glColorP4uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, type, color);
    }

    public static void glColorP4uiv(int type, IntBuffer color) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)color, 1);
        }
        GL33.nglColorP4uiv(type, MemoryUtil.memAddress(color));
    }

    public static void glSecondaryColorP3ui(int type, int color) {
        long __functionAddress = GL.getCapabilities().glSecondaryColorP3ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, type, color);
    }

    public static void nglSecondaryColorP3uiv(int type, long color) {
        long __functionAddress = GL.getCapabilities().glSecondaryColorP3uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, type, color);
    }

    public static void glSecondaryColorP3uiv(int type, IntBuffer color) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)color, 1);
        }
        GL33.nglSecondaryColorP3uiv(type, MemoryUtil.memAddress(color));
    }

    public static void glVertexAttribP1ui(int index, int type, boolean normalized, int value) {
        long __functionAddress = GL.getCapabilities().glVertexAttribP1ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, type, normalized, value);
    }

    public static void glVertexAttribP2ui(int index, int type, boolean normalized, int value) {
        long __functionAddress = GL.getCapabilities().glVertexAttribP2ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, type, normalized, value);
    }

    public static void glVertexAttribP3ui(int index, int type, boolean normalized, int value) {
        long __functionAddress = GL.getCapabilities().glVertexAttribP3ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, type, normalized, value);
    }

    public static void glVertexAttribP4ui(int index, int type, boolean normalized, int value) {
        long __functionAddress = GL.getCapabilities().glVertexAttribP4ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, type, normalized, value);
    }

    public static void nglVertexAttribP1uiv(int index, int type, boolean normalized, long value) {
        long __functionAddress = GL.getCapabilities().glVertexAttribP1uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, type, normalized, value);
    }

    public static void glVertexAttribP1uiv(int index, int type, boolean normalized, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        GL33.nglVertexAttribP1uiv(index, type, normalized, MemoryUtil.memAddress(value));
    }

    public static void nglVertexAttribP2uiv(int index, int type, boolean normalized, long value) {
        long __functionAddress = GL.getCapabilities().glVertexAttribP2uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, type, normalized, value);
    }

    public static void glVertexAttribP2uiv(int index, int type, boolean normalized, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        GL33.nglVertexAttribP2uiv(index, type, normalized, MemoryUtil.memAddress(value));
    }

    public static void nglVertexAttribP3uiv(int index, int type, boolean normalized, long value) {
        long __functionAddress = GL.getCapabilities().glVertexAttribP3uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, type, normalized, value);
    }

    public static void glVertexAttribP3uiv(int index, int type, boolean normalized, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        GL33.nglVertexAttribP3uiv(index, type, normalized, MemoryUtil.memAddress(value));
    }

    public static void nglVertexAttribP4uiv(int index, int type, boolean normalized, long value) {
        long __functionAddress = GL.getCapabilities().glVertexAttribP4uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, type, normalized, value);
    }

    public static void glVertexAttribP4uiv(int index, int type, boolean normalized, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        GL33.nglVertexAttribP4uiv(index, type, normalized, MemoryUtil.memAddress(value));
    }

    public static void glGenSamplers(int[] samplers) {
        long __functionAddress = GL.getCapabilities().glGenSamplers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, samplers.length, samplers);
    }

    public static void glDeleteSamplers(int[] samplers) {
        long __functionAddress = GL.getCapabilities().glDeleteSamplers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, samplers.length, samplers);
    }

    public static void glSamplerParameteriv(int sampler, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glSamplerParameteriv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterfv(int sampler, int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glSamplerParameterfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterIiv(int sampler, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glSamplerParameterIiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterIuiv(int sampler, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glSamplerParameterIuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameteriv(int sampler, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetSamplerParameteriv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterfv(int sampler, int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glGetSamplerParameterfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterIiv(int sampler, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetSamplerParameterIiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterIuiv(int sampler, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetSamplerParameterIuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetQueryObjecti64v(int id, int pname, long[] params) {
        long __functionAddress = GL.getCapabilities().glGetQueryObjecti64v;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, id, pname, params);
    }

    public static void glGetQueryObjectui64v(int id, int pname, long[] params) {
        long __functionAddress = GL.getCapabilities().glGetQueryObjectui64v;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, id, pname, params);
    }

    public static void glVertexP2uiv(int type, int[] value) {
        long __functionAddress = GL.getCapabilities().glVertexP2uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(value, 1);
        }
        JNI.callPV(__functionAddress, type, value);
    }

    public static void glVertexP3uiv(int type, int[] value) {
        long __functionAddress = GL.getCapabilities().glVertexP3uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(value, 1);
        }
        JNI.callPV(__functionAddress, type, value);
    }

    public static void glVertexP4uiv(int type, int[] value) {
        long __functionAddress = GL.getCapabilities().glVertexP4uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(value, 1);
        }
        JNI.callPV(__functionAddress, type, value);
    }

    public static void glTexCoordP1uiv(int type, int[] coords) {
        long __functionAddress = GL.getCapabilities().glTexCoordP1uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(coords, 1);
        }
        JNI.callPV(__functionAddress, type, coords);
    }

    public static void glTexCoordP2uiv(int type, int[] coords) {
        long __functionAddress = GL.getCapabilities().glTexCoordP2uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(coords, 1);
        }
        JNI.callPV(__functionAddress, type, coords);
    }

    public static void glTexCoordP3uiv(int type, int[] coords) {
        long __functionAddress = GL.getCapabilities().glTexCoordP3uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(coords, 1);
        }
        JNI.callPV(__functionAddress, type, coords);
    }

    public static void glTexCoordP4uiv(int type, int[] coords) {
        long __functionAddress = GL.getCapabilities().glTexCoordP4uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(coords, 1);
        }
        JNI.callPV(__functionAddress, type, coords);
    }

    public static void glMultiTexCoordP1uiv(int texture, int type, int[] coords) {
        long __functionAddress = GL.getCapabilities().glMultiTexCoordP1uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(coords, 1);
        }
        JNI.callPV(__functionAddress, texture, type, coords);
    }

    public static void glMultiTexCoordP2uiv(int texture, int type, int[] coords) {
        long __functionAddress = GL.getCapabilities().glMultiTexCoordP2uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(coords, 1);
        }
        JNI.callPV(__functionAddress, texture, type, coords);
    }

    public static void glMultiTexCoordP3uiv(int texture, int type, int[] coords) {
        long __functionAddress = GL.getCapabilities().glMultiTexCoordP3uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(coords, 1);
        }
        JNI.callPV(__functionAddress, texture, type, coords);
    }

    public static void glMultiTexCoordP4uiv(int texture, int type, int[] coords) {
        long __functionAddress = GL.getCapabilities().glMultiTexCoordP4uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(coords, 1);
        }
        JNI.callPV(__functionAddress, texture, type, coords);
    }

    public static void glNormalP3uiv(int type, int[] coords) {
        long __functionAddress = GL.getCapabilities().glNormalP3uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(coords, 1);
        }
        JNI.callPV(__functionAddress, type, coords);
    }

    public static void glColorP3uiv(int type, int[] color) {
        long __functionAddress = GL.getCapabilities().glColorP3uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(color, 1);
        }
        JNI.callPV(__functionAddress, type, color);
    }

    public static void glColorP4uiv(int type, int[] color) {
        long __functionAddress = GL.getCapabilities().glColorP4uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(color, 1);
        }
        JNI.callPV(__functionAddress, type, color);
    }

    public static void glSecondaryColorP3uiv(int type, int[] color) {
        long __functionAddress = GL.getCapabilities().glSecondaryColorP3uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(color, 1);
        }
        JNI.callPV(__functionAddress, type, color);
    }

    public static void glVertexAttribP1uiv(int index, int type, boolean normalized, int[] value) {
        long __functionAddress = GL.getCapabilities().glVertexAttribP1uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(value, 1);
        }
        JNI.callPV(__functionAddress, index, type, normalized, value);
    }

    public static void glVertexAttribP2uiv(int index, int type, boolean normalized, int[] value) {
        long __functionAddress = GL.getCapabilities().glVertexAttribP2uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(value, 1);
        }
        JNI.callPV(__functionAddress, index, type, normalized, value);
    }

    public static void glVertexAttribP3uiv(int index, int type, boolean normalized, int[] value) {
        long __functionAddress = GL.getCapabilities().glVertexAttribP3uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(value, 1);
        }
        JNI.callPV(__functionAddress, index, type, normalized, value);
    }

    public static void glVertexAttribP4uiv(int index, int type, boolean normalized, int[] value) {
        long __functionAddress = GL.getCapabilities().glVertexAttribP4uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(value, 1);
        }
        JNI.callPV(__functionAddress, index, type, normalized, value);
    }
}

