/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class APPLEContextLoggingFunctions {
    protected APPLEContextLoggingFunctions() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(CLCapabilities caps) {
        return Checks.checkFunctions(caps.clLogMessagesToSystemLogAPPLE, caps.clLogMessagesToStdoutAPPLE, caps.clLogMessagesToStderrAPPLE);
    }

    public static void nclLogMessagesToSystemLogAPPLE(long errstr, long private_info, long cb, long user_data) {
        long __functionAddress = CL.getICD().clLogMessagesToSystemLogAPPLE;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPPV(__functionAddress, errstr, private_info, cb, user_data);
    }

    public static void clLogMessagesToSystemLogAPPLE(ByteBuffer errstr, ByteBuffer private_info, long cb, ByteBuffer user_data) {
        APPLEContextLoggingFunctions.nclLogMessagesToSystemLogAPPLE(MemoryUtil.memAddress(errstr), MemoryUtil.memAddress(private_info), cb, MemoryUtil.memAddress(user_data));
    }

    public static void nclLogMessagesToStdoutAPPLE(long errstr, long private_info, long cb, long user_data) {
        long __functionAddress = CL.getICD().clLogMessagesToStdoutAPPLE;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPPV(__functionAddress, errstr, private_info, cb, user_data);
    }

    public static void clLogMessagesToStdoutAPPLE(ByteBuffer errstr, ByteBuffer private_info, long cb, ByteBuffer user_data) {
        APPLEContextLoggingFunctions.nclLogMessagesToStdoutAPPLE(MemoryUtil.memAddress(errstr), MemoryUtil.memAddress(private_info), cb, MemoryUtil.memAddress(user_data));
    }

    public static void nclLogMessagesToStderrAPPLE(long errstr, long private_info, long cb, long user_data) {
        long __functionAddress = CL.getICD().clLogMessagesToStderrAPPLE;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPPV(__functionAddress, errstr, private_info, cb, user_data);
    }

    public static void clLogMessagesToStderrAPPLE(ByteBuffer errstr, ByteBuffer private_info, long cb, ByteBuffer user_data) {
        APPLEContextLoggingFunctions.nclLogMessagesToStderrAPPLE(MemoryUtil.memAddress(errstr), MemoryUtil.memAddress(private_info), cb, MemoryUtil.memAddress(user_data));
    }
}

