/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTPlatformBase {
    protected EXTPlatformBase() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglGetPlatformDisplayEXT, caps.eglCreatePlatformWindowSurfaceEXT, caps.eglCreatePlatformPixmapSurfaceEXT);
    }

    public static long neglGetPlatformDisplayEXT(int platform, long native_display, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglGetPlatformDisplayEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(native_display);
        }
        return JNI.callPPP(__functionAddress, platform, native_display, attrib_list);
    }

    public static long eglGetPlatformDisplayEXT(int platform, long native_display, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return EXTPlatformBase.neglGetPlatformDisplayEXT(platform, native_display, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long neglCreatePlatformWindowSurfaceEXT(long dpy, long config, long native_window, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePlatformWindowSurfaceEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
            Checks.checkPointer(native_window);
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, native_window, attrib_list);
    }

    public static long eglCreatePlatformWindowSurfaceEXT(long dpy, long config, long native_window, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return EXTPlatformBase.neglCreatePlatformWindowSurfaceEXT(dpy, config, native_window, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long neglCreatePlatformPixmapSurfaceEXT(long dpy, long config, long native_pixmap, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePlatformPixmapSurfaceEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
            Checks.checkPointer(native_pixmap);
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, native_pixmap, attrib_list);
    }

    public static long eglCreatePlatformPixmapSurfaceEXT(long dpy, long config, long native_pixmap, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return EXTPlatformBase.neglCreatePlatformPixmapSurfaceEXT(dpy, config, native_pixmap, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long eglGetPlatformDisplayEXT(int platform, long native_display, int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglGetPlatformDisplayEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(native_display);
            if (attrib_list != null) {
                Checks.checkNT(attrib_list, 12344);
            }
        }
        return JNI.callPPP(__functionAddress, platform, native_display, attrib_list);
    }

    public static long eglCreatePlatformWindowSurfaceEXT(long dpy, long config, long native_window, int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePlatformWindowSurfaceEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
            Checks.checkPointer(native_window);
            if (attrib_list != null) {
                Checks.checkNT(attrib_list, 12344);
            }
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, native_window, attrib_list);
    }

    public static long eglCreatePlatformPixmapSurfaceEXT(long dpy, long config, long native_pixmap, int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePlatformPixmapSurfaceEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
            Checks.checkPointer(native_pixmap);
            if (attrib_list != null) {
                Checks.checkNT(attrib_list, 12344);
            }
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, native_pixmap, attrib_list);
    }
}

