/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTDeviceBase {
    public static final int EGL_BAD_DEVICE_EXT = 12843;
    public static final int EGL_DEVICE_EXT = 12844;
    public static final long EGL_NO_DEVICE_EXT = 0L;

    protected EXTDeviceBase() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglQueryDeviceAttribEXT, caps.eglQueryDeviceStringEXT, caps.eglQueryDisplayAttribEXT, caps.eglQueryDevicesEXT);
    }

    public static int neglQueryDeviceAttribEXT(long device, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglQueryDeviceAttribEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(device);
        }
        return JNI.callPPI(__functionAddress, device, attribute, value);
    }

    public static boolean eglQueryDeviceAttribEXT(long device, int attribute, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(value, 1);
        }
        return EXTDeviceBase.neglQueryDeviceAttribEXT(device, attribute, MemoryUtil.memAddress(value)) != 0;
    }

    public static long neglQueryDeviceStringEXT(long device, int name) {
        long __functionAddress = EGL.getCapabilities().eglQueryDeviceStringEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(device);
        }
        return JNI.callPP(__functionAddress, device, name);
    }

    public static String eglQueryDeviceStringEXT(long device, int name) {
        long __result = EXTDeviceBase.neglQueryDeviceStringEXT(device, name);
        return MemoryUtil.memASCII(__result);
    }

    public static int neglQueryDisplayAttribEXT(long dpy, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglQueryDisplayAttribEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
        }
        return JNI.callPPI(__functionAddress, dpy, attribute, value);
    }

    public static boolean eglQueryDisplayAttribEXT(long dpy, int attribute, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(value, 1);
        }
        return EXTDeviceBase.neglQueryDisplayAttribEXT(dpy, attribute, MemoryUtil.memAddress(value)) != 0;
    }

    public static int neglQueryDevicesEXT(int max_devices, long devices, long num_devices) {
        long __functionAddress = EGL.getCapabilities().eglQueryDevicesEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, max_devices, devices, num_devices);
    }

    public static boolean eglQueryDevicesEXT(PointerBuffer devices, IntBuffer num_devices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)num_devices, 1);
        }
        return EXTDeviceBase.neglQueryDevicesEXT(devices == null ? 0 : devices.remaining(), MemoryUtil.memAddressSafe(devices), MemoryUtil.memAddress(num_devices)) != 0;
    }

    public static boolean eglQueryDevicesEXT(PointerBuffer devices, int[] num_devices) {
        long __functionAddress = EGL.getCapabilities().eglQueryDevicesEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(num_devices, 1);
        }
        return JNI.callPPI(__functionAddress, devices == null ? 0 : devices.remaining(), MemoryUtil.memAddressSafe(devices), num_devices) != 0;
    }
}

