/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.InvalidMarkException;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public abstract class PointerBuffer
implements Comparable<PointerBuffer> {
    private static final Factory<?> FACTORY = Pointer.BITS64 ? x64.access$000() : x32.access$100();
    protected long address;
    protected Buffer container;
    protected int mark;
    protected int position;
    protected int limit;
    protected int capacity;

    PointerBuffer(long address, Buffer container, int mark, int position, int limit, int capacity) {
        this.address = address;
        this.container = container;
        this.mark = mark;
        this.position = position;
        this.limit = limit;
        this.capacity = capacity;
    }

    public static PointerBuffer allocateDirect(int capacity) {
        return FACTORY.allocateDirect(capacity);
    }

    public static PointerBuffer create(long address, int capacity) {
        return FACTORY.create(address, capacity);
    }

    public static PointerBuffer create(ByteBuffer source) {
        return FACTORY.create(source);
    }

    public static PointerBuffer setup(PointerBuffer buffer, long address, int capacity) {
        buffer.address = address;
        buffer.capacity = capacity;
        buffer.container = null;
        buffer.clear();
        return buffer;
    }

    public long address0() {
        return this.address;
    }

    public int capacity() {
        return this.capacity;
    }

    public int position() {
        return this.position;
    }

    public PointerBuffer position(int newPosition) {
        PointerBuffer.checkIndex(newPosition, this.limit);
        this.position = newPosition;
        if (this.position < this.mark) {
            this.mark = -1;
        }
        return this;
    }

    public int limit() {
        return this.limit;
    }

    public PointerBuffer limit(int newLimit) {
        PointerBuffer.checkIndex(newLimit, this.capacity);
        this.limit = newLimit;
        if (this.limit < this.position) {
            this.position = this.limit;
        }
        if (this.limit < this.mark) {
            this.mark = -1;
        }
        return this;
    }

    public PointerBuffer mark() {
        this.mark = this.position;
        return this;
    }

    public PointerBuffer reset() {
        int m = this.mark;
        if (m < 0) {
            throw new InvalidMarkException();
        }
        this.position = m;
        return this;
    }

    public PointerBuffer clear() {
        this.position = 0;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public PointerBuffer flip() {
        this.limit = this.position;
        this.position = 0;
        this.mark = -1;
        return this;
    }

    public PointerBuffer rewind() {
        this.position = 0;
        this.mark = -1;
        return this;
    }

    public int remaining() {
        return this.limit - this.position;
    }

    public boolean hasRemaining() {
        return this.position < this.limit;
    }

    public abstract PointerBuffer slice();

    public abstract PointerBuffer duplicate();

    public long get() {
        return MemoryUtil.memGetAddress(this.address + (long)(this.nextGetIndex() << Pointer.POINTER_SHIFT));
    }

    public static long get(ByteBuffer source) {
        if (source.limit() < source.position() + Pointer.POINTER_SIZE) {
            throw new BufferUnderflowException();
        }
        try {
            long l = MemoryUtil.memGetAddress(MemoryUtil.memAddress(source));
            return l;
        }
        finally {
            source.position(source.position() + Pointer.POINTER_SIZE);
        }
    }

    public PointerBuffer put(long p) {
        MemoryUtil.memPutAddress(this.address + (long)(this.nextPutIndex() << Pointer.POINTER_SHIFT), p);
        return this;
    }

    public static void put(ByteBuffer target, long p) {
        if (target.limit() < target.position() + Pointer.POINTER_SIZE) {
            throw new BufferOverflowException();
        }
        try {
            MemoryUtil.memPutAddress(MemoryUtil.memAddress(target), p);
        }
        finally {
            target.position(target.position() + Pointer.POINTER_SIZE);
        }
    }

    public long get(int index) {
        return MemoryUtil.memGetAddress(this.address + (long)(this.checkIndex(index) << Pointer.POINTER_SHIFT));
    }

    public static long get(ByteBuffer source, int index) {
        if (index < 0 || source.limit() < index + Pointer.POINTER_SIZE) {
            throw new IndexOutOfBoundsException();
        }
        return MemoryUtil.memGetAddress(MemoryUtil.memAddress0(source) + (long)index);
    }

    public PointerBuffer put(int index, long p) {
        MemoryUtil.memPutAddress(this.address + (long)(this.checkIndex(index) << Pointer.POINTER_SHIFT), p);
        return this;
    }

    public static void put(ByteBuffer target, int index, long p) {
        if (index < 0 || target.limit() < index + Pointer.POINTER_SIZE) {
            throw new IndexOutOfBoundsException();
        }
        MemoryUtil.memPutAddress(MemoryUtil.memAddress0(target) + (long)index, p);
    }

    public PointerBuffer put(Pointer pointer) {
        this.put(pointer.address());
        return this;
    }

    public PointerBuffer put(int index, Pointer pointer) {
        this.put(index, pointer.address());
        return this;
    }

    public PointerBuffer put(ByteBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(ShortBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(IntBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(LongBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(FloatBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(DoubleBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer putAddressOf(PointerBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index, ByteBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index, ShortBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index, IntBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index, LongBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index, FloatBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index, DoubleBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer putAddressOf(int index, PointerBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
        return this;
    }

    public ByteBuffer getByteBuffer(int size) {
        return MemoryUtil.memByteBuffer(this.get(), size);
    }

    public ShortBuffer getShortBuffer(int size) {
        return MemoryUtil.memShortBuffer(this.get(), size);
    }

    public IntBuffer getIntBuffer(int size) {
        return MemoryUtil.memIntBuffer(this.get(), size);
    }

    public LongBuffer getLongBuffer(int size) {
        return MemoryUtil.memLongBuffer(this.get(), size);
    }

    public FloatBuffer getFloatBuffer(int size) {
        return MemoryUtil.memFloatBuffer(this.get(), size);
    }

    public DoubleBuffer getDoubleBuffer(int size) {
        return MemoryUtil.memDoubleBuffer(this.get(), size);
    }

    public PointerBuffer getPointerBuffer(int size) {
        return MemoryUtil.memPointerBuffer(this.get(), size);
    }

    public String getStringASCII() {
        return MemoryUtil.memASCII(this.get());
    }

    public String getStringUTF8() {
        return MemoryUtil.memUTF8(this.get());
    }

    public String getStringUTF16() {
        return MemoryUtil.memUTF16(this.get());
    }

    public ByteBuffer getByteBuffer(int index, int size) {
        return MemoryUtil.memByteBuffer(this.get(index), size);
    }

    public ShortBuffer getShortBuffer(int index, int size) {
        return MemoryUtil.memShortBuffer(this.get(index), size);
    }

    public IntBuffer getIntBuffer(int index, int size) {
        return MemoryUtil.memIntBuffer(this.get(index), size);
    }

    public LongBuffer getLongBuffer(int index, int size) {
        return MemoryUtil.memLongBuffer(this.get(index), size);
    }

    public FloatBuffer getFloatBuffer(int index, int size) {
        return MemoryUtil.memFloatBuffer(this.get(index), size);
    }

    public DoubleBuffer getDoubleBuffer(int index, int size) {
        return MemoryUtil.memDoubleBuffer(this.get(index), size);
    }

    public PointerBuffer getPointerBuffer(int index, int size) {
        return MemoryUtil.memPointerBuffer(this.get(index), size);
    }

    public String getStringASCII(int index) {
        return MemoryUtil.memASCII(this.get(index));
    }

    public String getStringUTF8(int index) {
        return MemoryUtil.memUTF8(this.get(index));
    }

    public String getStringUTF16(int index) {
        return MemoryUtil.memUTF16(this.get(index));
    }

    public PointerBuffer get(long[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public PointerBuffer get(long[] dst, int offset, int length) {
        PointerBuffer.checkBounds(offset, length, dst.length);
        if (this.remaining() < length) {
            throw new BufferUnderflowException();
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public PointerBuffer put(PointerBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        int n = src.remaining();
        if (this.remaining() < n) {
            throw new BufferOverflowException();
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(src), MemoryUtil.memAddress(this), n << Pointer.POINTER_SHIFT);
        this.position(this.position + n);
        src.position(src.position + n);
        return this;
    }

    public PointerBuffer put(long[] src) {
        return this.put(src, 0, src.length);
    }

    public PointerBuffer put(long[] src, int offset, int length) {
        PointerBuffer.checkBounds(offset, length, src.length);
        if (this.remaining() < length) {
            throw new BufferOverflowException();
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public PointerBuffer compact() {
        MemoryUtil.memCopy(MemoryUtil.memAddress(this), this.address, this.remaining() << Pointer.POINTER_SHIFT);
        this.position(this.remaining());
        this.limit(this.capacity());
        this.mark = -1;
        return this;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    public String toString() {
        return this.getClass().getName() + "[pos=" + this.position() + " lim=" + this.limit() + " cap=" + this.capacity() + "]";
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + (int)this.get(i);
        }
        return h;
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof PointerBuffer)) {
            return false;
        }
        PointerBuffer that = (PointerBuffer)ob;
        if (this.remaining() != that.remaining()) {
            return false;
        }
        int p = this.position();
        int i = this.limit() - 1;
        int j = that.limit() - 1;
        while (i >= p) {
            long v2;
            long v1 = this.get(i);
            if (v1 != (v2 = that.get(j))) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    @Override
    public int compareTo(PointerBuffer that) {
        int n = this.position() + Math.min(this.remaining(), that.remaining());
        int i = this.position();
        int j = that.position();
        while (i < n) {
            long v2;
            long v1 = this.get(i);
            if (v1 != (v2 = that.get(j))) {
                if (v1 < v2) {
                    return -1;
                }
                return 1;
            }
            ++i;
            ++j;
        }
        return this.remaining() - that.remaining();
    }

    private static void checkBounds(int off, int len, int size) {
        if ((off | len | off + len | size - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    private int nextGetIndex() {
        if (this.limit <= this.position) {
            throw new BufferUnderflowException();
        }
        return this.position++;
    }

    private int nextPutIndex() {
        if (this.limit <= this.position) {
            throw new BufferOverflowException();
        }
        return this.position++;
    }

    private static void checkIndex(int index, int limit) {
        if (index < 0 || limit < index) {
            throw new IllegalArgumentException();
        }
    }

    private int checkIndex(int index) {
        if (index < 0 || this.limit < index) {
            throw new IndexOutOfBoundsException();
        }
        return index;
    }

    private static class x64
    extends PointerBuffer {
        private static final Factory<x64> FACTORYx64 = new Factory<x64>(){

            @Override
            public x64 allocateDirect(int capacity) {
                LongBuffer source = BufferUtils.createLongBuffer(capacity);
                return new x64(MemoryUtil.memAddress(source), source, -1, 0, capacity, capacity);
            }

            @Override
            public x64 create(long address, int capacity) {
                return new x64(address, null, -1, 0, capacity, capacity);
            }

            @Override
            public x64 create(ByteBuffer source) {
                int capacity = source.remaining() >> 2;
                return new x64(MemoryUtil.memAddress(source), source, -1, 0, capacity, capacity);
            }
        };

        protected x64(long address, Buffer container, int mark, int position, int limit, int capacity) {
            super(address, container, mark, position, limit, capacity);
        }

        @Override
        public PointerBuffer slice() {
            return new x64(MemoryUtil.memAddress(this), this.container, -1, 0, this.remaining(), this.remaining());
        }

        @Override
        public PointerBuffer duplicate() {
            return new x64(this.address, this.container, this.mark, this.position, this.limit, this.capacity);
        }

        static /* synthetic */ Factory access$000() {
            return FACTORYx64;
        }
    }

    private static class x32
    extends PointerBuffer {
        private static final Factory<x32> FACTORYx32 = new Factory<x32>(){

            @Override
            public x32 allocateDirect(int capacity) {
                IntBuffer source = BufferUtils.createIntBuffer(capacity);
                return new x32(MemoryUtil.memAddress(source), source, -1, 0, capacity, capacity);
            }

            @Override
            public x32 create(long address, int capacity) {
                return new x32(address, null, -1, 0, capacity, capacity);
            }

            @Override
            public x32 create(ByteBuffer source) {
                int capacity = source.remaining() >> 1;
                return new x32(MemoryUtil.memAddress(source), source, -1, 0, capacity, capacity);
            }
        };

        protected x32(long address, Buffer container, int mark, int position, int limit, int capacity) {
            super(address, container, mark, position, limit, capacity);
        }

        @Override
        public PointerBuffer slice() {
            return new x32(MemoryUtil.memAddress(this), this.container, -1, 0, this.remaining(), this.remaining());
        }

        @Override
        public PointerBuffer duplicate() {
            return new x32(this.address, this.container, this.mark, this.position, this.limit, this.capacity);
        }

        static /* synthetic */ Factory access$100() {
            return FACTORYx32;
        }
    }

    private static interface Factory<T extends PointerBuffer> {
        public T allocateDirect(int var1);

        public T create(long var1, int var3);

        public T create(ByteBuffer var1);
    }
}

