# apparmor.d - Full set of apparmor profiles
# Copyright (C) 2018-2021 Mikhail Morfikov
# Copyright (C) 2023-2024 Alexandre Pujol <alexandre@pujol.io>
# SPDX-License-Identifier: GPL-2.0-only

abi <abi/4.0>,

include <tunables/global>

@{name} = signal-desktop{,-beta}
@{domain} = org.chromium.Chromium
@{lib_dirs} = @{lib}/signal-desktop /opt/Signal{,?Beta}
@{config_dirs} = @{user_config_dirs}/Signal{,?Beta}
@{cache_dirs} = @{user_cache_dirs}/@{name}

@{exec_path} = @{lib_dirs}/@{name}
@{att} = /att/signal-desktop/
profile signal-desktop /{{,usr/}lib{,exec,32,64}/signal-desktop/signal-desktop{,-beta},opt/Signal{,?Beta}/signal-desktop{,-beta}} flags=(attach_disconnected,attach_disconnected.path=@{att}) {
  include <abstractions/attached/base>
  include <abstractions/audio-client>
  include <abstractions/bluetooth-observe>
  include <abstractions/bus-system>
  include <abstractions/camera>
  include <abstractions/common/electron>
  include <abstractions/devices-usb-read>
  include <abstractions/screen-inhibit>
  include <abstractions/screensaver>
  include <abstractions/secrets-service>
  include <abstractions/user-download-strict>

  network inet dgram,
  network inet6 dgram,
  network inet stream,
  network inet6 stream,
  network netlink raw,

  ptrace read peer=signal-desktop//&xdg-settings,

  @{exec_path} mrix,

  @{lib_dirs}/chrome-sandbox rpx,


  @{bin}/xdg-settings  rpx -> signal-desktop//&xdg-settings,
  @{open_path}         rpx -> child-open-strict,

  @{att}@{run}/systemd/inhibit/@{int}.ref rw,

  # Stacked profile: xdg-settings
  include <abstractions/consoles>
  include <abstractions/freedesktop.org>
  @{sh_path}        mr,
  @{bin}/{,e}grep  rix,
  @{bin}/basename  rix,
  @{bin}/cat        ix,
  @{bin}/cut       rix,
  @{bin}/head       ix,
  @{bin}/mkdir      ix,
  @{bin}/mktemp     ix,
  @{bin}/mv         ix,
  @{bin}/readlink   ix,
  @{bin}/realpath  rix,
  @{bin}/rm         ix,
  @{bin}/sed        ix,
  @{bin}/sleep      ix,
  @{bin}/sort       ix,
  @{bin}/touch      ix,
  @{bin}/tr         ix,
  @{bin}/uname      ix,
  @{bin}/wc         ix,
  # To set/get DE information
  @{bin}/gconftool{,-2}       ix,
  @{bin}/kde{,4}-config       ix,
  @{bin}/kwriteconfig{,5,6}   ix,
  @{bin}/qtxdg-mat            ix,
  @{bin}/dbus-send            Cx -> bus,
  @{bin}/kreadconfig{,5}      Px,
  @{bin}/xdg-mime             Px,
  @{bin}/xprop                Px,
  owner @{user_config_dirs}/xfce4/helpers.rc{,.@{rand6}} rw,
  owner @{user_share_dirs}/applications/{,**} rw,
  @{PROC}/version r,
  owner /dev/pts/@{u16} rw,
  profile bus flags=(complain) {
    include <abstractions/app/bus>
    include <abstractions/bus-session>
    include if exists <local/xdg-settings_bus>
  }
  include if exists <local/xdg-settings>

  include if exists <local/signal-desktop>
}

# vim:syntax=apparmor
