/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.awt;

import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Separator;
import dorkbox.systemTray.Status;
import dorkbox.systemTray.peer.MenuPeer;
import dorkbox.systemTray.ui.awt.AwtMenuItem;
import dorkbox.systemTray.ui.awt.AwtMenuItemCheckbox;
import dorkbox.systemTray.ui.awt.AwtMenuItemSeparator;
import dorkbox.systemTray.ui.awt.AwtMenuItemStatus;
import dorkbox.util.SwingUtil;
import java.awt.MenuShortcut;
import java.awt.PopupMenu;

class AwtMenu
implements MenuPeer {
    volatile java.awt.Menu _native;
    private final AwtMenu parent;

    AwtMenu(AwtMenu parent) {
        this.parent = parent;
        if (parent == null) {
            this._native = new PopupMenu();
        } else {
            this._native = new java.awt.Menu();
            parent._native.add(this._native);
        }
        this._native.addNotify();
    }

    @Override
    public void add(Menu parentMenu, Entry entry, int index) {
        SwingUtil.INSTANCE.invokeAndWaitQuietly(() -> {
            if (entry instanceof Menu) {
                AwtMenu menu = new AwtMenu(this);
                ((Menu)entry).bind(menu, parentMenu, parentMenu.getImageResizeUtil());
            } else if (entry instanceof Separator) {
                AwtMenuItemSeparator item = new AwtMenuItemSeparator(this);
                entry.bind(item, parentMenu, parentMenu.getImageResizeUtil());
            } else if (entry instanceof Checkbox) {
                AwtMenuItemCheckbox item = new AwtMenuItemCheckbox(this);
                ((Checkbox)entry).bind(item, parentMenu, parentMenu.getImageResizeUtil());
            } else if (entry instanceof Status) {
                AwtMenuItemStatus item = new AwtMenuItemStatus(this);
                ((Status)entry).bind(item, parentMenu, parentMenu.getImageResizeUtil());
            } else if (entry instanceof MenuItem) {
                AwtMenuItem item = new AwtMenuItem(this);
                ((MenuItem)entry).bind(item, parentMenu, parentMenu.getImageResizeUtil());
            }
        });
    }

    @Override
    public void setImage(MenuItem menuItem) {
    }

    @Override
    public void setEnabled(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setEnabled(menuItem.getEnabled()));
    }

    @Override
    public void setText(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setLabel(menuItem.getText()));
    }

    @Override
    public void setCallback(MenuItem menuItem) {
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        int vKey = SwingUtil.INSTANCE.getVirtualKey(menuItem.getShortcut());
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setShortcut(new MenuShortcut(vKey)));
    }

    @Override
    public void setTooltip(MenuItem menuItem) {
    }

    @Override
    public void remove() {
        SwingUtil.INSTANCE.invokeLater(() -> {
            this._native.removeAll();
            this._native.deleteShortcut();
            this._native.setEnabled(false);
            if (this.parent != null) {
                this.parent._native.remove(this._native);
            }
            this._native.removeNotify();
        });
    }
}

