/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.IntMap;
import dorkbox.collections.LockFreeIntBiMap;
import dorkbox.collections.ObjectIntMap;
import dorkbox.collections.StateException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u001a\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010$\n\u0002\b\t\u0018\u0000 ;*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u00032\u00020\u00052\u00020\u0006:\u0001;B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tB9\b\u0010\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u0012\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0010J\b\u0010\"\u001a\u00020#H\u0016J\u0015\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020\u0004H\u0016J\u0016\u0010*\u001a\u00020\u00042\u0006\u0010&\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010+J\u0015\u0010,\u001a\u0004\u0018\u00018\u00002\u0006\u0010&\u001a\u00020\u0004\u00a2\u0006\u0002\u0010-J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fJ\b\u0010.\u001a\u00020%H\u0016J\u001f\u0010/\u001a\u0004\u0018\u00010\u00042\u0006\u0010&\u001a\u00028\u00002\u0006\u0010)\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u00100J\u001e\u00101\u001a\u00020#2\u0014\u00102\u001a\u0010\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000403H\u0016J\u001a\u00104\u001a\u00020#2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000403J\u001b\u00106\u001a\u00020\u00042\u0006\u0010&\u001a\u00028\u00002\u0006\u0010)\u001a\u00020\u0004\u00a2\u0006\u0002\u00107J\u0015\u00108\u001a\u00020\u00042\u0006\u0010&\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010+J\u001c\u00109\u001a\u00020#2\u0014\u00105\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0004\u0018\u000103J\u001c\u0010:\u001a\u00020#2\u0014\u00105\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0004\u0018\u000103R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R&\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\u00150\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0012R\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001d\u00a8\u0006<"}, d2={"Ldorkbox/collections/LockFreeObjectIntBiMap;", "K", "", "", "", "", "Ljava/io/Serializable;", "()V", "defaultReturnValue", "(I)V", "forwardHashMap", "Ldorkbox/collections/ObjectIntMap;", "reverseHashMap", "Ldorkbox/collections/IntMap;", "inverse", "Ldorkbox/collections/LockFreeIntBiMap;", "(Ldorkbox/collections/ObjectIntMap;Ldorkbox/collections/IntMap;Ldorkbox/collections/LockFreeIntBiMap;I)V", "getDefaultReturnValue", "()I", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "reverseValues", "", "getReverseValues", "()Ljava/util/Collection;", "size", "getSize", "values", "getValues", "clear", "", "containsKey", "", "key", "(Ljava/lang/Object;)Z", "containsValue", "value", "get", "(Ljava/lang/Object;)Ljava/lang/Integer;", "getReverse", "(I)Ljava/lang/Object;", "isEmpty", "put", "(Ljava/lang/Object;I)Ljava/lang/Integer;", "putAll", "from", "", "putAllForce", "hashMap", "putForce", "(Ljava/lang/Object;I)I", "remove", "replaceAll", "replaceAllForce", "Companion", "Collections"})
public final class LockFreeObjectIntBiMap<K>
implements Map<K, Integer>,
Cloneable,
Serializable,
KMutableMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int defaultReturnValue;
    @NotNull
    private volatile ObjectIntMap<K> forwardHashMap;
    @NotNull
    private volatile IntMap<K> reverseHashMap;
    @NotNull
    private final LockFreeIntBiMap<K> inverse;
    @NotNull
    public static final String version = "2.4";
    private static final AtomicReferenceFieldUpdater<LockFreeObjectIntBiMap<?>, ObjectIntMap<?>> forwardREF = AtomicReferenceFieldUpdater.newUpdater(LockFreeObjectIntBiMap.class, ObjectIntMap.class, "forwardHashMap");
    private static final AtomicReferenceFieldUpdater<LockFreeObjectIntBiMap<?>, IntMap<?>> reverseREF = AtomicReferenceFieldUpdater.newUpdater(LockFreeObjectIntBiMap.class, IntMap.class, "reverseHashMap");

    public final int getDefaultReturnValue() {
        return this.defaultReturnValue;
    }

    public LockFreeObjectIntBiMap() {
        this(Integer.MIN_VALUE);
    }

    public LockFreeObjectIntBiMap(int defaultReturnValue) {
        this.forwardHashMap = new ObjectIntMap();
        this.reverseHashMap = new IntMap();
        this.inverse = new LockFreeIntBiMap<K>(this.reverseHashMap, this.forwardHashMap, this, defaultReturnValue);
        this.defaultReturnValue = defaultReturnValue;
    }

    public LockFreeObjectIntBiMap(@NotNull ObjectIntMap<K> forwardHashMap, @NotNull IntMap<K> reverseHashMap, @NotNull LockFreeIntBiMap<K> inverse, int defaultReturnValue) {
        Intrinsics.checkNotNullParameter(forwardHashMap, (String)"forwardHashMap");
        Intrinsics.checkNotNullParameter(reverseHashMap, (String)"reverseHashMap");
        Intrinsics.checkNotNullParameter(inverse, (String)"inverse");
        this.forwardHashMap = forwardHashMap;
        this.reverseHashMap = reverseHashMap;
        this.inverse = inverse;
        this.defaultReturnValue = defaultReturnValue;
    }

    public int getSize() {
        return this.forwardHashMap.size();
    }

    @Override
    public synchronized void clear() {
        this.forwardHashMap.clear();
        this.reverseHashMap.clear();
    }

    public boolean containsValue(int value) {
        return forwardREF.get(this).containsValue((Object)value);
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        if (key == null) {
            return false;
        }
        ObjectIntMap<?> objectIntMap = forwardREF.get(this);
        Intrinsics.checkNotNull(objectIntMap, (String)"null cannot be cast to non-null type dorkbox.collections.ObjectIntMap<K of dorkbox.collections.LockFreeObjectIntBiMap>");
        return objectIntMap.containsKey(key);
    }

    @NotNull
    public final LockFreeIntBiMap<K> inverse() {
        return this.inverse;
    }

    public final synchronized void replaceAll(@Nullable Map<K, Integer> hashMap) throws StateException {
        if (hashMap == null) {
            throw new NullPointerException("hashMap");
        }
        LockFreeObjectIntBiMap<K> biMap = new LockFreeObjectIntBiMap<K>();
        biMap.putAll(hashMap);
        this.forwardHashMap.clear();
        this.reverseHashMap.clear();
        this.forwardHashMap.putAll(biMap.forwardHashMap);
        this.reverseHashMap.putAll(biMap.reverseHashMap);
    }

    public final synchronized void replaceAllForce(@Nullable Map<K, Integer> hashMap) {
        if (hashMap == null) {
            throw new NullPointerException("hashMap");
        }
        this.forwardHashMap.clear();
        this.reverseHashMap.clear();
        this.putAllForce(hashMap);
    }

    @Override
    @Nullable
    public synchronized Integer put(@NotNull K key, int value) throws StateException {
        K prevReverseValue;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Integer prevForwardValue = this.forwardHashMap.put(key, value);
        if (prevForwardValue != null) {
            this.reverseHashMap.remove(prevForwardValue);
        }
        if ((prevReverseValue = this.reverseHashMap.put(value, key)) != null) {
            if (prevForwardValue != null) {
                this.forwardHashMap.put(key, prevForwardValue);
            } else {
                this.forwardHashMap.remove((Object)key);
            }
            this.reverseHashMap.put(value, prevReverseValue);
            throw new StateException("Value already exists. Keys and values must both be unique!");
        }
        return prevForwardValue;
    }

    public final synchronized int putForce(@NotNull K key, int value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int prevForwardValue = this.forwardHashMap.get(key, this.defaultReturnValue);
        this.forwardHashMap.put(key, value);
        if (prevForwardValue != this.defaultReturnValue) {
            this.reverseHashMap.remove((Object)prevForwardValue);
        }
        K prevReverseValue = this.reverseHashMap.get((Object)value);
        this.reverseHashMap.put(value, key);
        if (prevReverseValue != null) {
            this.forwardHashMap.remove(prevReverseValue, this.defaultReturnValue);
        }
        return prevForwardValue;
    }

    @Override
    public synchronized void putAll(@NotNull Map<? extends K, ? extends Integer> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        LockFreeObjectIntBiMap<K> biMap = new LockFreeObjectIntBiMap<K>();
        for (Map.Entry<K, Integer> entry : from.entrySet()) {
            K key = entry.getKey();
            int value = ((Number)entry.getValue()).intValue();
            biMap.put(key, value);
            if (this.forwardHashMap.containsKey(key)) {
                throw new StateException("Key already exists. Keys and values must both be unique!");
            }
            if (!this.reverseHashMap.containsKey((Object)value)) continue;
            throw new StateException("Value already exists. Keys and values must both be unique!");
        }
        this.forwardHashMap.putAll(biMap.forwardHashMap);
        this.reverseHashMap.putAll(biMap.reverseHashMap);
    }

    public final synchronized void putAllForce(@NotNull Map<K, Integer> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"hashMap");
        for (Map.Entry<K, Integer> entry : hashMap.entrySet()) {
            K key = entry.getKey();
            int value = ((Number)entry.getValue()).intValue();
            this.putForce(key, value);
        }
    }

    @Override
    @NotNull
    public synchronized Integer remove(@Nullable K key) {
        if (key == null) {
            return null;
        }
        Integer value = (Integer)this.forwardHashMap.remove((Object)key);
        TypeIntrinsics.asMutableMap((Object)this.reverseHashMap).remove(value);
        Integer n = value;
        return n != null ? n : this.defaultReturnValue;
    }

    @Override
    @NotNull
    public Integer get(@Nullable K key) {
        if (key == null) {
            return null;
        }
        ObjectIntMap<?> objectIntMap = forwardREF.get(this);
        Intrinsics.checkNotNullExpressionValue(objectIntMap, (String)"forwardREF[this]");
        Integer n = (Integer)((Map)objectIntMap).get(key);
        return n != null ? n : this.defaultReturnValue;
    }

    @Nullable
    public final K getReverse(int key) {
        return (K)reverseREF.get(this).get((Object)key);
    }

    @NotNull
    public Set<Map.Entry<K, Integer>> getEntries() {
        ObjectIntMap.Keys<?> keys = forwardREF.get(this).keys();
        Intrinsics.checkNotNull(keys, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<kotlin.collections.MutableMap.MutableEntry<K of dorkbox.collections.LockFreeObjectIntBiMap, kotlin.Int>>");
        return TypeIntrinsics.asMutableSet(keys);
    }

    @NotNull
    public Set<K> getKeys() {
        Set<?> set = forwardREF.get(this).keySet();
        Intrinsics.checkNotNull(set, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<K of dorkbox.collections.LockFreeObjectIntBiMap>");
        return TypeIntrinsics.asMutableSet(set);
    }

    @NotNull
    public Collection<Integer> getValues() {
        return forwardREF.get(this).values();
    }

    @Override
    public boolean isEmpty() {
        return forwardREF.get(this).isEmpty();
    }

    @NotNull
    public final Collection<K> getReverseValues() {
        Collection<?> collection = reverseREF.get(this).values();
        Intrinsics.checkNotNull(collection, (String)"null cannot be cast to non-null type kotlin.collections.MutableCollection<K of dorkbox.collections.LockFreeObjectIntBiMap>");
        return TypeIntrinsics.asMutableCollection(collection);
    }

    @NotNull
    public Object clone() {
        return super.clone();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Rn\u0010\u0003\u001ab\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0005\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00070\u0007 \u0006*0\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0005\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rn\u0010\b\u001ab\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0005\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\t0\t \u0006*0\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0005\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\t0\t\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldorkbox/collections/LockFreeObjectIntBiMap$Companion;", "", "()V", "forwardREF", "Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;", "Ldorkbox/collections/LockFreeObjectIntBiMap;", "kotlin.jvm.PlatformType", "Ldorkbox/collections/ObjectIntMap;", "reverseREF", "Ldorkbox/collections/IntMap;", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

