/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeHandlersKt;
import com.intellij.ui.DoubleClickListener;
import com.intellij.util.Processor;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\f\u0012\u0006\b\u0000\u0012\u00020\b\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\r\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u000e\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeHandlers;", "", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;)V", "enterKeyHandler", "Lcom/intellij/util/Processor;", "Ljava/awt/event/KeyEvent;", "getEnterKeyHandler", "()Lcom/intellij/util/Processor;", "setEnterKeyHandler", "(Lcom/intellij/util/Processor;)V", "doubleClickHandler", "Ljava/awt/event/MouseEvent;", "getDoubleClickHandler", "setDoubleClickHandler", "MyEnterListener", "MyDoubleClickListener", "intellij.platform.vcs.impl.shared"})
public final class ChangesTreeHandlers {
    @NotNull
    private final ChangesTree tree;
    @Nullable
    private Processor<? super KeyEvent> enterKeyHandler;
    @Nullable
    private Processor<? super MouseEvent> doubleClickHandler;

    public ChangesTreeHandlers(@NotNull ChangesTree tree) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        this.tree = tree;
        this.tree.addKeyListener(new MyEnterListener());
        new MyDoubleClickListener().installOn((Component)((Object)this.tree));
    }

    @Nullable
    public final Processor<? super KeyEvent> getEnterKeyHandler() {
        return this.enterKeyHandler;
    }

    public final void setEnterKeyHandler(@Nullable Processor<? super KeyEvent> processor) {
        this.enterKeyHandler = processor;
    }

    @Nullable
    public final Processor<? super MouseEvent> getDoubleClickHandler() {
        return this.doubleClickHandler;
    }

    public final void setDoubleClickHandler(@Nullable Processor<? super MouseEvent> processor) {
        this.doubleClickHandler = processor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeHandlers$MyDoubleClickListener;", "Lcom/intellij/ui/DoubleClickListener;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeHandlers;)V", "onDoubleClick", "", "e", "Ljava/awt/event/MouseEvent;", "intellij.platform.vcs.impl.shared"})
    private final class MyDoubleClickListener
    extends DoubleClickListener {
        protected boolean onDoubleClick(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Processor<? super MouseEvent> processor = ChangesTreeHandlers.this.getDoubleClickHandler();
            if (processor == null) {
                return false;
            }
            Processor<? super MouseEvent> handler = processor;
            TreePath clickPath = TreeUtil.getPathForLocation((JTree)((JTree)((Object)ChangesTreeHandlers.this.tree)), (int)e.getX(), (int)e.getY());
            if (clickPath == null) {
                return false;
            }
            if (ChangesTreeHandlers.this.tree.getPathIfCheckBoxClicked(e.getPoint()) != null) {
                return false;
            }
            return handler.process((Object)e);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeHandlers$MyEnterListener;", "Ljava/awt/event/KeyAdapter;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeHandlers;)V", "keyPressed", "", "e", "Ljava/awt/event/KeyEvent;", "intellij.platform.vcs.impl.shared"})
    private final class MyEnterListener
    extends KeyAdapter {
        @Override
        public void keyPressed(@NotNull KeyEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Processor<? super KeyEvent> processor = ChangesTreeHandlers.this.getEnterKeyHandler();
            if (processor == null) {
                return;
            }
            Processor<? super KeyEvent> handler = processor;
            if (10 != e.getKeyCode() || e.getModifiers() != 0) {
                return;
            }
            if (ChangesTreeHandlers.this.tree.getSelectionCount() <= 1 && !ChangesTreeHandlersKt.access$isLeafSelected(ChangesTreeHandlers.this.tree)) {
                return;
            }
            if (handler.process((Object)e)) {
                e.consume();
            }
        }
    }
}

