/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.Key;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\f2\u000b\u0010\u0014\u001a\u00070\t\u00a2\u0006\u0002\b\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0016J%\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u000b\u0010\u0014\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u001bH\u0016J\u0018\u0010!\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0016J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\tH\u0016J+\u0010#\u001a\u0004\u0018\u0001H$\"\n\b\u0000\u0010$*\u0004\u0018\u00010%2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H$0'H\u0016\u00a2\u0006\u0002\u0010(J3\u0010)\u001a\u00020\u0013\"\n\b\u0000\u0010$*\u0004\u0018\u00010%2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H$0'2\b\u0010*\u001a\u0004\u0018\u0001H$H\u0016\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/mock/MockMultiLineImmutableDocument;", "Lcom/intellij/openapi/editor/Document;", "text", "", "<init>", "(Ljava/lang/String;)V", "lines", "", "getImmutableCharSequence", "", "Lcom/intellij/openapi/util/NlsSafe;", "getLineCount", "", "getLineNumber", "offset", "getLineStartOffset", "line", "getLineEndOffset", "insertString", "", "s", "Lorg/jetbrains/annotations/NonNls;", "deleteString", "startOffset", "endOffset", "replaceString", "isWritable", "", "getModificationStamp", "", "createRangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "surviveOnExternalChange", "createGuardedBlock", "setText", "getUserData", "T", "", "key", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "putUserData", "value", "(Lcom/intellij/openapi/util/Key;Ljava/lang/Object;)V", "readOnlyException", "", "checkLineIndex", "index", "intellij.platform.testFramework"})
public final class MockMultiLineImmutableDocument
implements Document {
    @NotNull
    private final String text;
    @NotNull
    private final List<String> lines;

    public MockMultiLineImmutableDocument(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        char[] cArray = new char[]{'\n'};
        this.lines = StringsKt.split$default((CharSequence)this.text, (char[])cArray, (boolean)false, (int)0, (int)6, null);
    }

    @NotNull
    public CharSequence getImmutableCharSequence() {
        return this.text;
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public int getLineNumber(int offset) {
        int currentOffset = 0;
        int n = ((Collection)this.lines).size();
        for (int lineIndex = 0; lineIndex < n; ++lineIndex) {
            int lineLength = this.lines.get(lineIndex).length();
            if (offset <= currentOffset + lineLength) {
                return lineIndex;
            }
            currentOffset += lineLength + 1;
        }
        return this.lines.size() - 1;
    }

    public int getLineStartOffset(int line) {
        this.checkLineIndex(line);
        int offset = 0;
        for (int i = 0; i < line; ++i) {
            offset += this.lines.get(i).length() + 1;
        }
        return offset;
    }

    public int getLineEndOffset(int line) {
        this.checkLineIndex(line);
        return this.getLineStartOffset(line) + this.lines.get(line).length();
    }

    public void insertString(int offset, @NotNull CharSequence s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.readOnlyException();
        throw new KotlinNothingValueException();
    }

    public void deleteString(int startOffset, int endOffset) {
        this.readOnlyException();
        throw new KotlinNothingValueException();
    }

    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.readOnlyException();
        throw new KotlinNothingValueException();
    }

    public boolean isWritable() {
        return false;
    }

    public long getModificationStamp() {
        return 0L;
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        throw new UnsupportedOperationException("RangeMarkers not supported in " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
    }

    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        throw new UnsupportedOperationException("Guarded blocks not supported in " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
    }

    public void setText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        throw new UnsupportedOperationException(Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + " is read-only");
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return null;
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
    }

    private final Void readOnlyException() {
        throw new UnsupportedOperationException(Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + " is read-only");
    }

    private final void checkLineIndex(int index) {
        if (index < 0 || index >= this.getLineCount()) {
            throw new IndexOutOfBoundsException("Wrong line: " + index + ". Available lines count: " + this.getLineCount());
        }
    }
}

