/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.vale;

import ai.grazie.rules.vale.YamlBasedRule;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.tools.StringTools;
import org.yaml.snakeyaml.nodes.Node;

class CapitalizationRule
extends YamlBasedRule {
    private static final Pattern wordOfLetters = Pattern.compile("\\b\\p{L}+");
    private final String message;
    private final Predicate<String> isException;
    private final List<String> indicators;
    private final JLanguageTool lt;
    private final Predicate<AnalyzedSentence> checker;

    CapitalizationRule(YamlBasedRule.MetaData meta, Node node, String match, String message, Predicate<String> isException, String style, List<String> indicators, @NotNull JLanguageTool lt) {
        super(meta, node);
        this.message = message;
        this.isException = isException;
        this.indicators = indicators;
        this.lt = lt;
        this.checker = "$title".equals(match) ? sentence -> this.isTitleOk((AnalyzedSentence)sentence, style) : ("$sentence".equals(match) ? this::isSentenceOk : ("$lower".equals(match) ? s -> s.getText().toLowerCase(Locale.ROOT).equals(s.getText()) : ("$upper".equals(match) ? s -> s.getText().toUpperCase(Locale.ROOT).equals(s.getText()) : CapitalizationRule.patternChecker(match))));
    }

    private static Predicate<AnalyzedSentence> patternChecker(String match) {
        Pattern pattern = Pattern.compile(match);
        return s -> pattern.matcher(s.getText()).matches();
    }

    @Override
    public List<YamlBasedRule.RuleMatch> check(String text) {
        return CapitalizationRule.checkAnalyzedSentences(this.lt, text, this::checkSentence);
    }

    private List<YamlBasedRule.RuleMatch> checkSentence(AnalyzedSentence sentence) {
        String text = sentence.getText();
        return this.checker.test(sentence) ? List.of() : List.of(new YamlBasedRule.RuleMatch(0, text.length(), String.format(this.message, text), List.of()));
    }

    private boolean isSentenceOk(AnalyzedSentence sentence) {
        List<AnalyzedTokenReadings> words = CapitalizationRule.wordTokens(sentence);
        if (words.isEmpty()) {
            return true;
        }
        if (!StringTools.startsWithUppercase((String)words.get(0).getToken())) {
            return false;
        }
        int okCount = 1;
        for (int i = 1; i < words.size(); ++i) {
            String word = words.get(i).getToken();
            if (!word.toLowerCase(Locale.ROOT).equals(word) && !StringTools.isAllUppercase((String)word) && !this.isException.test(word) && !this.isAfterIndicator(sentence, words.get(i))) continue;
            ++okCount;
        }
        return words.size() > 1 && (double)okCount / (double)words.size() > 0.8;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAfterIndicator(AnalyzedSentence sentence, AnalyzedTokenReadings token) {
        if (this.indicators.isEmpty()) return false;
        if (!this.indicators.stream().anyMatch(sentence.getText().substring(0, token.getStartPos()).trim()::endsWith)) return false;
        return true;
    }

    private boolean isTitleOk(AnalyzedSentence sentence, String style) {
        List<AnalyzedTokenReadings> words = CapitalizationRule.wordTokens(sentence);
        int okCount = 0;
        for (int i = 0; i < words.size(); ++i) {
            AnalyzedTokenReadings token = words.get(i);
            String word = token.getToken();
            if (!StringTools.startsWithUppercase((String)word) && !this.isException.test(word) && (i <= 0 || i >= words.size() - 1 || !CapitalizationRule.isShortLowercaseAllowed(token, word, style))) continue;
            ++okCount;
        }
        return words.size() > 1 && (double)okCount / (double)words.size() > 0.8;
    }

    private static List<AnalyzedTokenReadings> wordTokens(AnalyzedSentence sentence) {
        return ((StreamEx)StreamEx.of((Object[])sentence.getTokensWithoutWhitespace()).filter(t -> wordOfLetters.matcher(t.getToken()).matches())).toList();
    }

    private static boolean isShortLowercaseAllowed(AnalyzedTokenReadings token, String word, String style) {
        if (token.hasPosTag("DT") && word.length() <= 3) {
            return true;
        }
        if (token.hasPosTag("CC") || token.hasPosTag("IN") || token.hasPosTag("TO")) {
            return word.length() <= 3 || "Chicago".equals(style);
        }
        return false;
    }
}

