/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.functionTypeComments.psi.PyParameterTypeList;
import com.jetbrains.python.codeInsight.typeHints.PyTypeHintFile;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypeParameter;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.validation.PyAnnotationHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PyStarAnnotatorVisitor
extends PyElementVisitor {
    @NotNull
    private final PyAnnotationHolder myHolder;

    PyStarAnnotatorVisitor(@NotNull PyAnnotationHolder holder) {
        if (holder == null) {
            PyStarAnnotatorVisitor.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    public void visitPyStarExpression(@NotNull PyStarExpression node) {
        if (node == null) {
            PyStarAnnotatorVisitor.$$$reportNull$$$0(1);
        }
        super.visitPyStarExpression(node);
        PsiElement parent = node.getParent();
        if (parent.getParent() instanceof PyTypeHintFile) {
            return;
        }
        if (!(node.isAssignmentTarget() || PyStarAnnotatorVisitor.allowedUnpacking(node) || parent instanceof PyParameterTypeList || parent instanceof PyTypeParameter || parent instanceof PyAnnotation && PyStarAnnotatorVisitor.isVariadicArg(parent.getParent()))) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.can.t.use.starred.expression.here", new Object[0])).create();
        }
    }

    private static boolean allowedUnpacking(@NotNull PyStarExpression starExpression) {
        PsiElement tupleParent;
        if (starExpression == null) {
            PyStarAnnotatorVisitor.$$$reportNull$$$0(2);
        }
        if (!starExpression.isUnpacking()) {
            return false;
        }
        PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)starExpression, (Class[])new Class[]{PyParenthesizedExpression.class});
        return !(parent instanceof PyTupleExpression) || !((tupleParent = parent.getParent()) instanceof PyYieldExpression) || !((PyYieldExpression)tupleParent).isDelegating();
    }

    public static boolean isVariadicArg(@Nullable PsiElement parameter) {
        return parameter instanceof PyNamedParameter && ((PyNamedParameter)parameter).isPositionalContainer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starExpression";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/validation/PyStarAnnotatorVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyStarExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "allowedUnpacking";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

