/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.view.shellIntegration.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.containers.DisposableWrapperList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModel;
import org.jetbrains.plugins.terminal.util.TerminalUtilKt;
import org.jetbrains.plugins.terminal.view.TerminalOffset;
import org.jetbrains.plugins.terminal.view.TerminalOutputModel;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalBlockBase;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalCommandBlock;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalCommandExecutionEvent;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalCommandExecutionListener;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalCommandFinishedEvent;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalCommandStartedEvent;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalOutputStatus;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalShellIntegration;
import org.jetbrains.plugins.terminal.view.shellIntegration.impl.TerminalBlocksModelImpl;
import org.jetbrains.plugins.terminal.view.shellIntegration.impl.TerminalCommandBlockImpl;
import org.jetbrains.plugins.terminal.view.shellIntegration.impl.TerminalCommandFinishedEventImpl;
import org.jetbrains.plugins.terminal.view.shellIntegration.impl.TerminalCommandStartedEventImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 *2\u00020\u0001:\u0001*B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010!\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020)H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006+"}, d2={"Lorg/jetbrains/plugins/terminal/view/shellIntegration/impl/TerminalShellIntegrationImpl;", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalShellIntegration;", "outputModel", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "sessionModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;Lkotlinx/coroutines/CoroutineScope;)V", "blocksModel", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/impl/TerminalBlocksModelImpl;", "getBlocksModel", "()Lorg/jetbrains/plugins/terminal/view/shellIntegration/impl/TerminalBlocksModelImpl;", "commandExecutionListeners", "Lcom/intellij/util/containers/DisposableWrapperList;", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalCommandExecutionListener;", "addCommandExecutionListener", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "listener", "mutableOutputStatus", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalOutputStatus;", "outputStatus", "Lkotlinx/coroutines/flow/StateFlow;", "getOutputStatus", "()Lkotlinx/coroutines/flow/StateFlow;", "onPromptStarted", "offset", "Lorg/jetbrains/plugins/terminal/view/TerminalOffset;", "onPromptFinished", "onCommandStarted", "command", "", "onCommandFinished", "exitCode", "", "fireCommandExecutionListeners", "event", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalCommandExecutionEvent;", "Companion", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalShellIntegrationImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalShellIntegrationImpl.kt\norg/jetbrains/plugins/terminal/view/shellIntegration/impl/TerminalShellIntegrationImpl\n+ 2 TerminalBlocksModelImpl.kt\norg/jetbrains/plugins/terminal/view/shellIntegration/impl/TerminalBlocksModelImpl\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,92:1\n71#2,2:93\n71#2,2:95\n71#2,2:97\n13#3:99\n*S KotlinDebug\n*F\n+ 1 TerminalShellIntegrationImpl.kt\norg/jetbrains/plugins/terminal/view/shellIntegration/impl/TerminalShellIntegrationImpl\n*L\n43#1:93,2\n50#1:95,2\n60#1:97,2\n80#1:99\n*E\n"})
public final class TerminalShellIntegrationImpl
implements TerminalShellIntegration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalBlocksModelImpl blocksModel;
    @NotNull
    private final DisposableWrapperList<TerminalCommandExecutionListener> commandExecutionListeners;
    @NotNull
    private final MutableStateFlow<TerminalOutputStatus> mutableOutputStatus;
    @NotNull
    private final StateFlow<TerminalOutputStatus> outputStatus;
    @NotNull
    private static final Logger LOG;

    public TerminalShellIntegrationImpl(@NotNull TerminalOutputModel outputModel, @NotNull TerminalSessionModel sessionModel, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.outputModel = outputModel;
        this.blocksModel = new TerminalBlocksModelImpl(this.outputModel, sessionModel, CoroutineScopeKt.asDisposable((CoroutineScope)coroutineScope));
        this.commandExecutionListeners = new DisposableWrapperList();
        this.mutableOutputStatus = StateFlowKt.MutableStateFlow((Object)TerminalOutputStatus.WaitingForPrompt.INSTANCE);
        this.outputStatus = FlowKt.asStateFlow(this.mutableOutputStatus);
    }

    @Override
    @NotNull
    public TerminalBlocksModelImpl getBlocksModel() {
        return this.blocksModel;
    }

    @Override
    public void addCommandExecutionListener(@NotNull Disposable parentDisposable, @NotNull TerminalCommandExecutionListener listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.commandExecutionListeners.add((Object)listener2, parentDisposable);
    }

    @Override
    @NotNull
    public StateFlow<TerminalOutputStatus> getOutputStatus() {
        return this.outputStatus;
    }

    public final void onPromptStarted(@NotNull TerminalOffset offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        this.getBlocksModel().startNewBlock(offset);
        this.mutableOutputStatus.setValue((Object)TerminalOutputStatus.WaitingForPrompt.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    public final void onPromptFinished(@NotNull TerminalOffset offset) {
        void block;
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        TerminalBlocksModelImpl this_$iv = this.getBlocksModel();
        boolean $i$f$updateActiveCommandBlock = false;
        TerminalBlockBase terminalBlockBase = this_$iv.getActiveBlock();
        Intrinsics.checkNotNull((Object)terminalBlockBase, (String)"null cannot be cast to non-null type org.jetbrains.plugins.terminal.view.shellIntegration.impl.TerminalCommandBlockImpl");
        TerminalCommandBlockImpl terminalCommandBlockImpl = (TerminalCommandBlockImpl)terminalBlockBase;
        TerminalBlocksModelImpl terminalBlocksModelImpl = this_$iv;
        boolean bl = false;
        terminalBlocksModelImpl.setActiveBlock(TerminalCommandBlockImpl.copy$default((TerminalCommandBlockImpl)block, null, null, null, offset, null, null, null, null, 247, null));
        this.mutableOutputStatus.setValue((Object)TerminalOutputStatus.TypingCommand.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    public final void onCommandStarted(@NotNull TerminalOffset offset, @NotNull String command2) {
        void block;
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        TerminalBlocksModelImpl this_$iv = this.getBlocksModel();
        boolean $i$f$updateActiveCommandBlock = false;
        TerminalBlockBase terminalBlockBase = this_$iv.getActiveBlock();
        Intrinsics.checkNotNull((Object)terminalBlockBase, (String)"null cannot be cast to non-null type org.jetbrains.plugins.terminal.view.shellIntegration.impl.TerminalCommandBlockImpl");
        TerminalCommandBlockImpl terminalCommandBlockImpl = (TerminalCommandBlockImpl)terminalBlockBase;
        TerminalBlocksModelImpl terminalBlocksModelImpl = this_$iv;
        boolean bl = false;
        terminalBlocksModelImpl.setActiveBlock(TerminalCommandBlockImpl.copy$default((TerminalCommandBlockImpl)block, null, null, null, null, offset, null, command2, null, 175, null));
        this.mutableOutputStatus.setValue((Object)TerminalOutputStatus.ExecutingCommand.INSTANCE);
        TerminalBlockBase terminalBlockBase2 = this.getBlocksModel().getActiveBlock();
        Intrinsics.checkNotNull((Object)terminalBlockBase2, (String)"null cannot be cast to non-null type org.jetbrains.plugins.terminal.view.shellIntegration.TerminalCommandBlock");
        TerminalCommandBlock block2 = (TerminalCommandBlock)terminalBlockBase2;
        this.fireCommandExecutionListeners(new TerminalCommandStartedEventImpl(this.outputModel, block2));
    }

    /*
     * WARNING - void declaration
     */
    public final void onCommandFinished(int exitCode) {
        void block;
        TerminalBlocksModelImpl this_$iv = this.getBlocksModel();
        boolean $i$f$updateActiveCommandBlock = false;
        TerminalBlockBase terminalBlockBase = this_$iv.getActiveBlock();
        Intrinsics.checkNotNull((Object)terminalBlockBase, (String)"null cannot be cast to non-null type org.jetbrains.plugins.terminal.view.shellIntegration.impl.TerminalCommandBlockImpl");
        TerminalCommandBlockImpl terminalCommandBlockImpl = (TerminalCommandBlockImpl)terminalBlockBase;
        TerminalBlocksModelImpl terminalBlocksModelImpl = this_$iv;
        boolean bl = false;
        terminalBlocksModelImpl.setActiveBlock(TerminalCommandBlockImpl.copy$default((TerminalCommandBlockImpl)block, null, null, null, null, null, null, null, exitCode, 127, null));
        this.mutableOutputStatus.setValue((Object)TerminalOutputStatus.WaitingForPrompt.INSTANCE);
        TerminalBlockBase terminalBlockBase2 = this.getBlocksModel().getActiveBlock();
        Intrinsics.checkNotNull((Object)terminalBlockBase2, (String)"null cannot be cast to non-null type org.jetbrains.plugins.terminal.view.shellIntegration.TerminalCommandBlock");
        TerminalCommandBlock block2 = (TerminalCommandBlock)terminalBlockBase2;
        this.fireCommandExecutionListeners(new TerminalCommandFinishedEventImpl(this.outputModel, block2));
    }

    private final void fireCommandExecutionListeners(TerminalCommandExecutionEvent event) {
        TerminalUtilKt.fireListenersAndLogAllExceptions((List)this.commandExecutionListeners, LOG, "Exception during handling " + event, arg_0 -> TerminalShellIntegrationImpl.fireCommandExecutionListeners$lambda$0(event, arg_0));
    }

    private static final Unit fireCommandExecutionListeners$lambda$0(TerminalCommandExecutionEvent $event, TerminalCommandExecutionListener it) {
        TerminalCommandExecutionEvent terminalCommandExecutionEvent = $event;
        if (terminalCommandExecutionEvent instanceof TerminalCommandStartedEvent) {
            it.commandStarted((TerminalCommandStartedEvent)$event);
        } else if (terminalCommandExecutionEvent instanceof TerminalCommandFinishedEvent) {
            it.commandFinished((TerminalCommandFinishedEvent)$event);
        } else {
            throw new IllegalStateException(("Unexpected event: " + $event).toString());
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalShellIntegrationImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/terminal/view/shellIntegration/impl/TerminalShellIntegrationImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

