/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.legacy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.klimt.creole.CreoleContext;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Stripe;
import net.sourceforge.plantuml.klimt.creole.StripeStyle;
import net.sourceforge.plantuml.klimt.creole.StripeStyleType;
import net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.style.ISkinSimple;
import net.sourceforge.plantuml.utils.CharHidder;

public class CreoleStripeSimpleParser {
    private final String line;
    private final StripeStyle style;
    private final CreoleMode modeSimpleLine;
    private final FontConfiguration fontConfiguration;
    private final ISkinSimple skinParam;
    private static final Pattern2 SECTION_TITLE_PATTERN = Pattern2.cmpile("^==([^=]*)==$");
    private static final Pattern2 SECTION_SEPARATOR_PATTERN = Pattern2.cmpile("^===*==$");
    private static final Pattern2 DOUBLE_DOT_DELIMITED_LINE = Pattern2.cmpile("^\\.\\.([^\\.]*)\\.\\.$");
    private static final Pattern2 ASTERISK_PREFIXED_LINE_PATTERN = Pattern2.cmpile("^(\\*+)([^*]+(?:[^*]|\\*\\*[^*]+\\*\\*)*)$");
    private static final Pattern2 ASTERISK_HEADER_LINE_PATTERN = Pattern2.cmpile("^(\\*+)([%s].+)$");
    private static final Pattern2 HASH_HEADING_PATTERN = Pattern2.cmpile("^(#+)(.+)$");
    private static final Pattern2 EQUALS_HEADING_PATTERN = Pattern2.cmpile("^(=+)(.+)$");
    private static final Pattern2 SECTION_HEADER_PATTERN = Pattern2.cmpile("^--([^-]*)--$");

    public CreoleStripeSimpleParser(String line, CreoleContext creoleContext, FontConfiguration fontConfiguration, ISkinSimple skinParam, CreoleMode mode) {
        Matcher2 m2;
        Matcher2 m1;
        this.fontConfiguration = fontConfiguration;
        this.modeSimpleLine = mode;
        this.skinParam = Objects.requireNonNull(skinParam);
        if (mode == CreoleMode.NO_CREOLE) {
            this.line = line;
            this.style = new StripeStyle(StripeStyleType.NORMAL, 0, '\u0000');
            return;
        }
        Matcher2 m4 = SECTION_HEADER_PATTERN.matcher(line);
        if (m4.find()) {
            this.line = m4.group(1);
            this.style = new StripeStyle(StripeStyleType.HORIZONTAL_LINE, 0, '-');
            return;
        }
        Matcher2 m5 = SECTION_TITLE_PATTERN.matcher(line);
        if (m5.find()) {
            this.line = m5.group(1);
            this.style = new StripeStyle(StripeStyleType.HORIZONTAL_LINE, 0, '=');
            return;
        }
        Matcher2 m5b = SECTION_SEPARATOR_PATTERN.matcher(line);
        if (m5b.find()) {
            this.line = "";
            this.style = new StripeStyle(StripeStyleType.HORIZONTAL_LINE, 0, '=');
            return;
        }
        Matcher2 m7 = DOUBLE_DOT_DELIMITED_LINE.matcher(line);
        if (m7.find()) {
            this.line = m7.group(1);
            this.style = new StripeStyle(StripeStyleType.HORIZONTAL_LINE, 0, '.');
            return;
        }
        if (mode == CreoleMode.FULL && (m1 = ASTERISK_PREFIXED_LINE_PATTERN.matcher(line)).find()) {
            this.line = StringUtils.trin(m1.group(2));
            int order = m1.group(1).length() - 1;
            this.style = new StripeStyle(StripeStyleType.LIST_WITHOUT_NUMBER, order, '\u0000');
            return;
        }
        if (mode == CreoleMode.FULL && (m1 = ASTERISK_HEADER_LINE_PATTERN.matcher(line)).find()) {
            this.line = StringUtils.trin(m1.group(2));
            int order = m1.group(1).length() - 1;
            this.style = new StripeStyle(StripeStyleType.LIST_WITHOUT_NUMBER, order, '\u0000');
            return;
        }
        if (mode == CreoleMode.FULL && (m2 = HASH_HEADING_PATTERN.matcher(CharHidder.hide(line))).find()) {
            this.line = StringUtils.trin(CharHidder.unhide(m2.group(2)));
            int order = CharHidder.unhide(m2.group(1)).length() - 1;
            this.style = new StripeStyle(StripeStyleType.LIST_WITH_NUMBER, order, '\u0000');
            return;
        }
        Matcher2 m3 = EQUALS_HEADING_PATTERN.matcher(line);
        if (m3.find()) {
            this.line = StringUtils.trin(m3.group(2));
            int order = m3.group(1).length() - 1;
            this.style = new StripeStyle(StripeStyleType.HEADING, order, '\u0000');
            return;
        }
        this.line = line;
        this.style = new StripeStyle(StripeStyleType.NORMAL, 0, '\u0000');
    }

    public List<Stripe> createStripes(CreoleContext context, HorizontalAlignment align) {
        ArrayList<StripeSimple> result = new ArrayList<StripeSimple>();
        for (String singleLine : this.line.split("\ue100")) {
            StripeSimple stripe = new StripeSimple(this.fontConfiguration, this.style, context, this.skinParam, this.modeSimpleLine);
            stripe.setCellAlignment(align);
            stripe.analyzeAndAdd(singleLine);
            result.add(stripe);
        }
        return Collections.unmodifiableList(result);
    }
}

