/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.transport;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.neuralsearch.sparse.SparseSettings;

public class TransportUtils {
    public static void validateSparseIndices(ClusterState state, String[] concreteIndices, String operationName) {
        List invalidIndexNames = Arrays.stream(concreteIndices).filter(indexName -> {
            Boolean isSparseIndex = Optional.ofNullable(state).map(ClusterState::metadata).map(metadata -> metadata.index(indexName)).map(IndexMetadata::getSettings).map(arg_0 -> SparseSettings.IS_SPARSE_INDEX_SETTING.get(arg_0)).orElse(false);
            return isSparseIndex == false;
        }).collect(Collectors.toList());
        if (!invalidIndexNames.isEmpty()) {
            throw new OpenSearchStatusException(String.format(Locale.ROOT, "Request rejected. Indices [%s] don't support %s operation.", String.join((CharSequence)", ", invalidIndexNames), operationName), RestStatus.BAD_REQUEST, new Object[0]);
        }
    }
}

