/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.poi.openxml4j.exceptions.InvalidOperationException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.BasicObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.BitReader;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.BitWriter;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.GuidUtil;

public class ExGuid
extends BasicObject {
    public static final int ExtendedGUIDNullType = 0;
    public static final int ExtendedGUID5BitUintType = 4;
    public static final int ExtendedGUID10BitUintType = 32;
    public static final int ExtendedGUID17BitUintType = 64;
    public static final int ExtendedGUID32BitUintType = 128;
    public int type;
    public int value;
    public UUID guid;

    public ExGuid(int value, UUID identifier) {
        this.value = value;
        this.guid = identifier;
    }

    public ExGuid(ExGuid guid2) {
        this.value = guid2.value;
        this.guid = guid2.guid;
        this.type = guid2.type;
    }

    public ExGuid() {
        this.guid = GuidUtil.emptyGuid();
    }

    @Override
    public List<Byte> serializeToByteList() throws IOException {
        BitWriter bitWriter = new BitWriter(21);
        if (this.guid.equals(GuidUtil.emptyGuid())) {
            bitWriter.appendUInit32(0, 8);
        } else if (this.value >= 0 && this.value <= 31) {
            bitWriter.appendUInit32(4, 3);
            bitWriter.appendUInit32(this.value, 5);
            bitWriter.appendGUID(this.guid);
        } else if (this.value >= 32 && this.value <= 1023) {
            bitWriter.appendUInit32(32, 6);
            bitWriter.appendUInit32(this.value, 10);
            bitWriter.appendGUID(this.guid);
        } else if (this.value >= 1024 && this.value <= 131071) {
            bitWriter.appendUInit32(64, 7);
            bitWriter.appendUInit32(this.value, 17);
            bitWriter.appendGUID(this.guid);
        } else if (this.value >= 131072) {
            bitWriter.appendUInit32(128, 8);
            bitWriter.appendUInit32(this.value, 32);
            bitWriter.appendGUID(this.guid);
        }
        return bitWriter.getByteList();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExGuid) {
            ExGuid another = (ExGuid)obj;
            if (this.guid != null && another.guid != null) {
                return another.guid.equals(this.guid) && another.value == this.value;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.guid.hashCode() + Integer.valueOf(this.value).hashCode();
    }

    @Override
    protected int doDeserializeFromByteArray(byte[] byteArray, int startIndex) throws IOException {
        int numberOfContinousZeroBit;
        BitReader bitReader = new BitReader(byteArray, startIndex);
        for (numberOfContinousZeroBit = 0; numberOfContinousZeroBit < 8 && bitReader.moveNext() && !bitReader.getCurrent(); ++numberOfContinousZeroBit) {
        }
        switch (numberOfContinousZeroBit) {
            case 2: {
                this.value = bitReader.readUInt32(5);
                this.guid = bitReader.readGuid();
                this.type = 4;
                return 17;
            }
            case 5: {
                this.value = bitReader.readUInt32(10);
                this.guid = bitReader.readGuid();
                this.type = 32;
                return 18;
            }
            case 6: {
                this.value = bitReader.readUInt32(17);
                this.guid = bitReader.readGuid();
                this.type = 64;
                return 19;
            }
            case 7: {
                this.value = bitReader.readUInt32(32);
                this.guid = bitReader.readGuid();
                this.type = 128;
                return 21;
            }
            case 8: {
                this.guid = GuidUtil.emptyGuid();
                this.type = 0;
                return 1;
            }
        }
        throw new InvalidOperationException("Failed to parse the ExGuid, the type value is unexpected");
    }
}

