/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpoint;

public class DescribeVerifiedAccessEndpointsPublisher
implements SdkPublisher<DescribeVerifiedAccessEndpointsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeVerifiedAccessEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeVerifiedAccessEndpointsPublisher(Ec2AsyncClient client, DescribeVerifiedAccessEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeVerifiedAccessEndpointsPublisher(Ec2AsyncClient client, DescribeVerifiedAccessEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeVerifiedAccessEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeVerifiedAccessEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VerifiedAccessEndpoint> verifiedAccessEndpoints() {
        Function<DescribeVerifiedAccessEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.verifiedAccessEndpoints() != null) {
                return response.verifiedAccessEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeVerifiedAccessEndpointsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeVerifiedAccessEndpointsResponseFetcher
    implements AsyncPageFetcher<DescribeVerifiedAccessEndpointsResponse> {
        private DescribeVerifiedAccessEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVerifiedAccessEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeVerifiedAccessEndpointsResponse> nextPage(DescribeVerifiedAccessEndpointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVerifiedAccessEndpointsPublisher.this.client.describeVerifiedAccessEndpoints(DescribeVerifiedAccessEndpointsPublisher.this.firstRequest);
            }
            return DescribeVerifiedAccessEndpointsPublisher.this.client.describeVerifiedAccessEndpoints((DescribeVerifiedAccessEndpointsRequest)((Object)DescribeVerifiedAccessEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

