function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _createSuper(t) { var r = _isNativeReflectConstruct(); return function () { var e, o = _getPrototypeOf(t); if (r) { var s = _getPrototypeOf(this).constructor; e = Reflect.construct(o, arguments, s); } else e = o.apply(this, arguments); return _possibleConstructorReturn(this, e); }; }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React, { cloneElement, Component } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { tabbable } from 'tabbable';
import { keysOf } from '../common';
import { EuiIcon } from '../icon';
import { EuiResizeObserver } from '../observer/resize_observer';
import { cascadingMenuKeys } from '../../services';
import { EuiContextMenuItem } from './context_menu_item';
var titleSizeToClassNameMap = {
  s: 'euiContextMenuPanelTitle--small',
  m: null
};
export var SIZES = keysOf(titleSizeToClassNameMap);
var transitionDirectionAndTypeToClassNameMap = {
  next: {
    in: 'euiContextMenuPanel-txInLeft',
    out: 'euiContextMenuPanel-txOutLeft'
  },
  previous: {
    in: 'euiContextMenuPanel-txInRight',
    out: 'euiContextMenuPanel-txOutRight'
  }
};
export var EuiContextMenuPanel = /*#__PURE__*/function (_Component) {
  _inherits(EuiContextMenuPanel, _Component);
  var _super = _createSuper(EuiContextMenuPanel);
  function EuiContextMenuPanel(props) {
    var _this;
    _classCallCheck(this, EuiContextMenuPanel);
    _this = _super.call(this, props);
    _defineProperty(_assertThisInitialized(_this), "_isMounted", false);
    _defineProperty(_assertThisInitialized(_this), "backButton", null);
    _defineProperty(_assertThisInitialized(_this), "content", null);
    _defineProperty(_assertThisInitialized(_this), "panel", null);
    _defineProperty(_assertThisInitialized(_this), "incrementFocusedItemIndex", function (amount) {
      var nextFocusedItemIndex;
      if (_this.state.focusedItemIndex === undefined) {
        // If this is the beginning of the user's keyboard navigation of the menu, then we'll focus
        // either the first or last item.
        nextFocusedItemIndex = amount < 0 ? _this.state.menuItems.length - 1 : 0;
      } else {
        nextFocusedItemIndex = _this.state.focusedItemIndex + amount;
        if (nextFocusedItemIndex < 0) {
          nextFocusedItemIndex = _this.state.menuItems.length - 1;
        } else if (nextFocusedItemIndex === _this.state.menuItems.length) {
          nextFocusedItemIndex = 0;
        }
      }
      _this.setState({
        focusedItemIndex: nextFocusedItemIndex
      });
    });
    _defineProperty(_assertThisInitialized(_this), "onKeyDown", function (event) {
      // If this panel contains items you can use the left arrow key to go back at any time.
      // But if it doesn't contain items, then you have to focus on the back button specifically,
      // since there could be content inside the panel which requires use of the left arrow key,
      // e.g. text inputs.
      var _this$props = _this.props,
        items = _this$props.items,
        showPreviousPanel = _this$props.showPreviousPanel;
      if (items && items.length || document.activeElement === _this.backButton || document.activeElement === _this.panel) {
        if (event.key === cascadingMenuKeys.ARROW_LEFT) {
          if (showPreviousPanel) {
            event.preventDefault();
            event.stopPropagation();
            showPreviousPanel();
            if (_this.props.onUseKeyboardToNavigate) {
              _this.props.onUseKeyboardToNavigate();
            }
          }
        }
      }
      if (_this.props.items && _this.props.items.length) {
        switch (event.key) {
          case cascadingMenuKeys.TAB:
            // We need to sync up with the user if s/he is tabbing through the items.
            var focusedItemIndex = _this.state.menuItems.indexOf(document.activeElement);
            _this.setState({
              focusedItemIndex: focusedItemIndex >= 0 && focusedItemIndex < _this.state.menuItems.length ? focusedItemIndex : undefined
            });
            break;
          case cascadingMenuKeys.ARROW_UP:
            event.preventDefault();
            _this.incrementFocusedItemIndex(-1);
            if (_this.props.onUseKeyboardToNavigate) {
              _this.props.onUseKeyboardToNavigate();
            }
            break;
          case cascadingMenuKeys.ARROW_DOWN:
            event.preventDefault();
            _this.incrementFocusedItemIndex(1);
            if (_this.props.onUseKeyboardToNavigate) {
              _this.props.onUseKeyboardToNavigate();
            }
            break;
          case cascadingMenuKeys.ARROW_RIGHT:
            if (_this.props.showNextPanel) {
              event.preventDefault();
              _this.props.showNextPanel(_this.state.focusedItemIndex);
              if (_this.props.onUseKeyboardToNavigate) {
                _this.props.onUseKeyboardToNavigate();
              }
            }
            break;
          default:
            break;
        }
      }
    });
    _defineProperty(_assertThisInitialized(_this), "onTransitionComplete", function () {
      if (_this.props.onTransitionComplete) {
        _this.props.onTransitionComplete();
      }
    });
    _defineProperty(_assertThisInitialized(_this), "menuItemRef", function (index, node) {
      // There's a weird bug where if you navigate to a panel without items, then this callback
      // is still invoked, so we have to do a truthiness check.
      if (node) {
        // Store all menu items.
        _this.state.menuItems[index] = node;
      }
    });
    _defineProperty(_assertThisInitialized(_this), "panelRef", function (node) {
      _this.panel = node;
      _this.updateHeight();
    });
    _defineProperty(_assertThisInitialized(_this), "contentRef", function (node) {
      _this.content = node;
    });
    _this.state = {
      prevProps: {
        items: _this.props.items
      },
      menuItems: [],
      focusedItemIndex: props.initialFocusedItemIndex,
      currentHeight: undefined
    };
    return _this;
  }
  _createClass(EuiContextMenuPanel, [{
    key: "updateFocus",
    value: function updateFocus() {
      var _this2 = this;
      // Give positioning time to render before focus is applied. Otherwise page jumps.
      requestAnimationFrame(function () {
        if (!_this2._isMounted) {
          return;
        }

        // If this panel has lost focus, then none of its content should be focused.
        if (!_this2.props.hasFocus) {
          if (_this2.panel && _this2.panel.contains(document.activeElement)) {
            document.activeElement.blur();
          }
          return;
        }

        // Setting focus while transitioning causes the animation to glitch, so we have to wait
        // until it's finished before we focus anything.
        if (_this2.props.transitionType) {
          return;
        }

        // `focusedItemIndex={-1}` specifies that the panel itself should be focused.
        // This should only be used when the panel does not have `item`s
        // and preventing autofocus is desired, which is an uncommon case.
        if (_this2.panel && _this2.state.focusedItemIndex === -1) {
          _this2.panel.focus();
          return;
        }

        // If there aren't any items then this is probably a form or something.
        if (!_this2.state.menuItems.length) {
          // If we've already focused on something inside the panel, everything's fine.
          if (_this2.panel && _this2.panel.contains(document.activeElement)) {
            return;
          }

          // Otherwise let's focus the first tabbable item and expedite input from the user.
          if (_this2.content) {
            var tabbableItems = tabbable(_this2.content, {
              displayCheck: 'legacy-full'
            });
            if (tabbableItems.length) {
              tabbableItems[0].focus();
            }
          }
          return;
        }

        // If an item is focused, focus it.
        if (_this2.state.focusedItemIndex !== undefined) {
          _this2.state.menuItems[_this2.state.focusedItemIndex].focus();
          return;
        }

        // Focus on the panel as a last resort.
        if (_this2.panel && !_this2.panel.contains(document.activeElement)) {
          _this2.panel.focus();
        }
      });
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.updateFocus();
      this._isMounted = true;
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this._isMounted = false;
    }
  }, {
    key: "getWatchedPropsForItems",
    value: function getWatchedPropsForItems(items) {
      // This lets us compare prevProps and nextProps among items so we can re-render if our items
      // have changed.
      var watchedItemProps = this.props.watchedItemProps; // Create fingerprint of all item's watched properties
      if (items.length && watchedItemProps && watchedItemProps.length) {
        return JSON.stringify(items.map(function (item) {
          // Create object of item properties and values
          var props = {
            key: item.key
          };
          watchedItemProps.forEach(function (prop) {
            props[prop] = item.props[prop];
          });
          return props;
        }));
      }
      return null;
    }
  }, {
    key: "didItemsChange",
    value: function didItemsChange(prevItems, nextItems) {
      // If the count of items has changed then update
      if (prevItems.length !== nextItems.length) {
        return true;
      }

      // Check if any watched item properties changed by quick string comparison
      if (this.getWatchedPropsForItems(nextItems) !== this.getWatchedPropsForItems(prevItems)) {
        return true;
      }
    }
  }, {
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState) {
      // Prevent calling `this.updateFocus()` below if we don't have to.
      if (nextProps.hasFocus !== this.props.hasFocus) {
        return true;
      }
      if (nextProps.transitionType !== this.props.transitionType) {
        return true;
      }
      if (nextState.focusedItemIndex !== this.state.focusedItemIndex) {
        return true;
      }

      // **
      // this component should have either items or children,
      // if there are items we can determine via `watchedItemProps` if we should update
      // if there are children we can't know if they have changed so return true
      // **

      if (this.props.items && this.props.items.length > 0 || nextProps.items && nextProps.items.length > 0) {
        if (this.didItemsChange(this.props.items, nextProps.items)) {
          return true;
        }
      }

      // it's not possible (in any good way) to know if `children` has changed, assume they might have
      if (this.props.children != null) {
        return true;
      }
      return false;
    }
  }, {
    key: "updateHeight",
    value: function updateHeight() {
      var currentHeight = this.panel ? this.panel.clientHeight : 0;
      if (this.state.height !== currentHeight) {
        if (this.props.onHeightChange) {
          this.props.onHeightChange(currentHeight);
          this.setState({
            height: currentHeight
          });
        }
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      this.updateFocus();
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;
      var _this$props2 = this.props,
        children = _this$props2.children,
        className = _this$props2.className,
        onClose = _this$props2.onClose,
        title = _this$props2.title,
        onHeightChange = _this$props2.onHeightChange,
        transitionType = _this$props2.transitionType,
        transitionDirection = _this$props2.transitionDirection,
        onTransitionComplete = _this$props2.onTransitionComplete,
        onUseKeyboardToNavigate = _this$props2.onUseKeyboardToNavigate,
        hasFocus = _this$props2.hasFocus,
        items = _this$props2.items,
        watchedItemProps = _this$props2.watchedItemProps,
        initialFocusedItemIndex = _this$props2.initialFocusedItemIndex,
        showNextPanel = _this$props2.showNextPanel,
        showPreviousPanel = _this$props2.showPreviousPanel,
        size = _this$props2.size,
        rest = _objectWithoutProperties(_this$props2, ["children", "className", "onClose", "title", "onHeightChange", "transitionType", "transitionDirection", "onTransitionComplete", "onUseKeyboardToNavigate", "hasFocus", "items", "watchedItemProps", "initialFocusedItemIndex", "showNextPanel", "showPreviousPanel", "size"]);
      var panelTitle;
      if (title) {
        var titleClasses = classNames('euiContextMenuPanelTitle', size && titleSizeToClassNameMap[size]);
        if (Boolean(onClose)) {
          panelTitle = /*#__PURE__*/React.createElement("button", {
            className: titleClasses,
            type: "button",
            onClick: onClose,
            ref: function ref(node) {
              _this3.backButton = node;
            },
            "data-test-subj": "contextMenuPanelTitleButton"
          }, /*#__PURE__*/React.createElement("span", {
            className: "euiContextMenu__itemLayout"
          }, /*#__PURE__*/React.createElement(EuiIcon, {
            type: "arrowLeft",
            size: "m",
            className: "euiContextMenu__icon"
          }), /*#__PURE__*/React.createElement("span", {
            className: "euiContextMenu__text"
          }, title)));
        } else {
          panelTitle = /*#__PURE__*/React.createElement("div", {
            className: titleClasses
          }, /*#__PURE__*/React.createElement("span", {
            className: "euiContextMenu__itemLayout"
          }, title));
        }
      }
      var classes = classNames('euiContextMenuPanel', className, transitionDirection && transitionType && transitionDirectionAndTypeToClassNameMap[transitionDirection] ? transitionDirectionAndTypeToClassNameMap[transitionDirection][transitionType] : undefined);
      var content = items && items.length ? items.map(function (MenuItem, index) {
        var cloneProps = {
          buttonRef: function buttonRef(node) {
            return _this3.menuItemRef(index, node);
          }
        };
        if (size) {
          cloneProps.size = size;
        }
        return MenuItem.type === EuiContextMenuItem ? /*#__PURE__*/cloneElement(MenuItem, cloneProps) : MenuItem;
      }) : children;
      return /*#__PURE__*/React.createElement("div", _extends({
        ref: this.panelRef,
        className: classes,
        onKeyDown: this.onKeyDown,
        tabIndex: -1,
        onAnimationEnd: this.onTransitionComplete
      }, rest), panelTitle, /*#__PURE__*/React.createElement("div", {
        ref: this.contentRef
      }, /*#__PURE__*/React.createElement(EuiResizeObserver, {
        onResize: function onResize() {
          return _this3.updateHeight();
        }
      }, function (resizeRef) {
        return /*#__PURE__*/React.createElement("div", {
          ref: resizeRef
        }, content);
      })));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      var needsUpdate = false;
      var nextState = {};

      // Clear refs to menuItems if we're getting new ones.
      if (nextProps.items !== prevState.prevProps.items) {
        needsUpdate = true;
        nextState.menuItems = [];
        nextState.prevProps = {
          items: nextProps.items
        };
      }
      if (needsUpdate) {
        return nextState;
      }
      return null;
    }
  }]);
  return EuiContextMenuPanel;
}(Component);
_defineProperty(EuiContextMenuPanel, "defaultProps", {
  hasFocus: true,
  items: []
});
EuiContextMenuPanel.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  hasFocus: PropTypes.bool,
  initialFocusedItemIndex: PropTypes.number,
  items: PropTypes.arrayOf(PropTypes.element.isRequired),
  onClose: PropTypes.func,
  onHeightChange: PropTypes.func,
  onTransitionComplete: PropTypes.func,
  onUseKeyboardToNavigate: PropTypes.func,
  showNextPanel: PropTypes.func,
  showPreviousPanel: PropTypes.func,
  title: PropTypes.node,
  transitionDirection: PropTypes.oneOf(["next", "previous"]),
  transitionType: PropTypes.oneOf(["in", "out"]),
  watchedItemProps: PropTypes.arrayOf(PropTypes.string.isRequired),
  /**
     * Alters the size of the items and the title
     */
  size: PropTypes.any
};