/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hc.client5.http.entity.mime.AbstractMultipartFormat;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MimeField;
import org.apache.hc.client5.http.entity.mime.MultipartPart;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.net.PercentCodec;

class HttpRFC7578Multipart
extends AbstractMultipartFormat {
    private final List<MultipartPart> parts;
    private final HttpMultipartMode mode;

    public HttpRFC7578Multipart(Charset charset, String boundary, List<MultipartPart> parts, String preamble, String epilogue, HttpMultipartMode mode) {
        super(charset, boundary, preamble, epilogue);
        this.parts = parts;
        this.mode = mode != null ? mode : HttpMultipartMode.STRICT;
    }

    public HttpRFC7578Multipart(Charset charset, String boundary, List<MultipartPart> parts, HttpMultipartMode mode) {
        this(charset, boundary, parts, null, null, mode);
    }

    @Override
    public List<MultipartPart> getParts() {
        return this.parts;
    }

    @Override
    protected void formatMultipartHeader(MultipartPart part, OutputStream out) throws IOException {
        for (MimeField field : part.getHeader()) {
            if ("Content-Disposition".equalsIgnoreCase(field.getName())) {
                HttpRFC7578Multipart.writeBytes(field.getName(), this.charset, out);
                HttpRFC7578Multipart.writeBytes(FIELD_SEP, out);
                HttpRFC7578Multipart.writeBytes(field.getValue(), out);
                List<NameValuePair> parameters = field.getParameters();
                for (int i = 0; i < parameters.size(); ++i) {
                    NameValuePair parameter = parameters.get(i);
                    String name = parameter.getName();
                    String value = parameter.getValue();
                    HttpRFC7578Multipart.writeBytes("; ", out);
                    HttpRFC7578Multipart.writeBytes(name, out);
                    HttpRFC7578Multipart.writeBytes("=\"", out);
                    if (value != null) {
                        StringBuilder sb;
                        if (name.equalsIgnoreCase("filename*")) {
                            if (value.startsWith("UTF-8''")) {
                                HttpRFC7578Multipart.writeBytes(value, StandardCharsets.US_ASCII, out);
                            } else {
                                sb = new StringBuilder(value.length() + 16);
                                sb.append("UTF-8''");
                                PercentCodec.RFC5987.encode(sb, (CharSequence)value);
                                HttpRFC7578Multipart.writeBytes(sb.toString(), StandardCharsets.US_ASCII, out);
                            }
                        } else if (name.equalsIgnoreCase("filename")) {
                            if (this.mode == HttpMultipartMode.EXTENDED) {
                                sb = new StringBuilder(value.length() + 8);
                                PercentCodec.RFC5987.encode(sb, (CharSequence)value);
                                HttpRFC7578Multipart.writeBytes(sb.toString(), StandardCharsets.US_ASCII, out);
                            } else {
                                HttpRFC7578Multipart.writeBytes(value, StandardCharsets.ISO_8859_1, out);
                            }
                        } else {
                            HttpRFC7578Multipart.writeBytes(value, out);
                        }
                    }
                    HttpRFC7578Multipart.writeBytes("\"", out);
                }
                HttpRFC7578Multipart.writeBytes(CR_LF, out);
                continue;
            }
            HttpRFC7578Multipart.writeField(field, this.charset, out);
        }
    }
}

