/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.http;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mediathek.tool.ApplicationConfiguration;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.commons.configuration2.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lmediathek/tool/http/OkHttpProxyAuthenticator;", "", "<init>", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "value", "Lokhttp3/Authenticator;", "proxyAuthenticator", "getProxyAuthenticator", "()Lokhttp3/Authenticator;", "setupProxyAuthenticator", "", "createAuthenticator", "prxUser", "", "prxPassword", "Companion", "MediathekView"})
public final class OkHttpProxyAuthenticator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger = LogManager.getLogger();
    @Nullable
    private Authenticator proxyAuthenticator;
    @NotNull
    private static final String HTTP_PROXY_AUTHORIZATION = "Proxy-Authorization";

    public OkHttpProxyAuthenticator() {
        this.setupProxyAuthenticator();
    }

    @Nullable
    public final Authenticator getProxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void setupProxyAuthenticator() {
        String prxUser = System.getProperty("http.proxyUser");
        String prxPassword = System.getProperty("http.proxyPassword");
        this.proxyAuthenticator = null;
        if (prxUser != null && prxPassword != null && ((CharSequence)prxUser).length() > 0 && ((CharSequence)prxPassword).length() > 0) {
            this.proxyAuthenticator = this.createAuthenticator(prxUser, prxPassword);
            this.logger.info("Proxy Authentication from environment vars: ({})", (Object)prxUser);
            return;
        }
        Configuration config = ApplicationConfiguration.getConfiguration();
        prxUser = config.getString("http.proxy.user", "");
        prxPassword = config.getString("http.proxy.password", "");
        String string = prxUser;
        Intrinsics.checkNotNull((Object)string);
        if (((CharSequence)string).length() > 0) {
            string = prxPassword;
            Intrinsics.checkNotNull((Object)string);
            if (((CharSequence)string).length() > 0) {
                string = prxUser;
                Intrinsics.checkNotNull((Object)string);
                String string2 = string;
                string = prxPassword;
                Intrinsics.checkNotNull((Object)string);
                this.proxyAuthenticator = this.createAuthenticator(string2, string);
                this.logger.info("Proxy Authentication from application settings: ({})", (Object)prxUser);
                return;
            }
        }
        this.proxyAuthenticator = null;
    }

    private final Authenticator createAuthenticator(String prxUser, String prxPassword) {
        return (arg_0, arg_1) -> OkHttpProxyAuthenticator.createAuthenticator$lambda$0(prxUser, prxPassword, arg_0, arg_1);
    }

    private static final Request createAuthenticator$lambda$0(String $prxUser, String $prxPassword, Route route, Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (response.request().header(HTTP_PROXY_AUTHORIZATION) != null) {
            return null;
        }
        String credential = Credentials.basic$default((String)$prxUser, (String)$prxPassword, null, (int)4, null);
        return response.request().newBuilder().header(HTTP_PROXY_AUTHORIZATION, credential).build();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lmediathek/tool/http/OkHttpProxyAuthenticator$Companion;", "", "<init>", "()V", "HTTP_PROXY_AUTHORIZATION", "", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

