/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.regex;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.attribute.Attributes;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.representations.idm.authorization.RegexPolicyRepresentation;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.JsonUtils;

public class RegexPolicyProvider
implements PolicyProvider {
    private static final Logger logger = Logger.getLogger(RegexPolicyProvider.class);
    private final BiFunction<Policy, AuthorizationProvider, RegexPolicyRepresentation> representationFunction;

    public RegexPolicyProvider(BiFunction<Policy, AuthorizationProvider, RegexPolicyRepresentation> representationFunction) {
        this.representationFunction = representationFunction;
    }

    public void close() {
    }

    public void evaluate(Evaluation evaluation) {
        AuthorizationProvider authorizationProvider = evaluation.getAuthorizationProvider();
        RegexPolicyRepresentation policy = this.representationFunction.apply(evaluation.getPolicy(), authorizationProvider);
        String value = this.getClaimValue(evaluation, policy);
        if (value == null) {
            return;
        }
        Pattern pattern = Pattern.compile(policy.getPattern());
        Matcher matcher = pattern.matcher(value);
        if (matcher.matches()) {
            evaluation.grant();
            logger.debugf("policy %s evaluated with status %s on identity %s and claim value %s", new Object[]{policy.getName(), evaluation.getEffect(), evaluation.getContext().getIdentity().getId(), this.getClaimValue(evaluation, policy)});
        }
    }

    private String getClaimValue(Evaluation evaluation, RegexPolicyRepresentation policy) {
        Attributes attributes = policy.isTargetContextAttributes() ? evaluation.getContext().getAttributes() : evaluation.getContext().getIdentity().getAttributes();
        String targetClaim = policy.getTargetClaim();
        try {
            if (JsonUtils.hasPath((String)targetClaim)) {
                return this.resolveJsonValue(attributes, targetClaim);
            }
            return this.resolveSimpleValue(attributes, targetClaim);
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to resolve value from claim: " + targetClaim, cause);
        }
    }

    private String resolveSimpleValue(Attributes attributes, String targetClaim) {
        Attributes.Entry value = attributes.getValue(targetClaim);
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value.asString(0);
    }

    private String resolveJsonValue(Attributes attributes, String targetClaim) throws IOException {
        List paths = JsonUtils.splitClaimPath((String)targetClaim);
        if (paths.isEmpty()) {
            return null;
        }
        Attributes.Entry attribute = attributes.getValue((String)paths.get(0));
        if (attribute == null || attribute.isEmpty()) {
            return null;
        }
        JsonNode node = (JsonNode)JsonSerialization.readValue((String)attribute.asString(0), JsonNode.class);
        String path = String.join((CharSequence)".", paths.subList(1, paths.size()));
        return Optional.ofNullable(JsonUtils.getJsonValue((JsonNode)node, (String)path)).map(Object::toString).orElse(null);
    }
}

