/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.kafka;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.kafka.KafkaClientMetrics;
import io.quarkus.runtime.ShutdownEvent;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;
import org.jboss.logging.Logger;

@ApplicationScoped
public class KafkaEventObserver {
    private static final Logger log = Logger.getLogger(KafkaEventObserver.class);
    final MeterRegistry registry = Metrics.globalRegistry;
    Map<Object, KafkaClientMetrics> clientMetrics = new HashMap<Object, KafkaClientMetrics>();

    public synchronized void consumerCreated(@Observes Consumer<?, ?> consumer) {
        KafkaClientMetrics metrics = this.clientMetrics.remove(consumer);
        if (metrics == null) {
            metrics = new KafkaClientMetrics(consumer);
            try {
                metrics.bindTo(this.registry);
                this.clientMetrics.put(consumer, metrics);
            }
            catch (Throwable t) {
                log.warnf(t, "Unable to register metrics for Kafka consumer %s", consumer);
                this.tryToClose((AutoCloseable)metrics);
            }
        } else {
            this.tryToClose((AutoCloseable)metrics);
        }
    }

    public synchronized void producerCreated(@Observes Producer<?, ?> producer) {
        KafkaClientMetrics metrics = this.clientMetrics.remove(producer);
        if (metrics == null) {
            metrics = new KafkaClientMetrics(producer);
            try {
                metrics.bindTo(this.registry);
                this.clientMetrics.put(producer, metrics);
            }
            catch (Throwable t) {
                log.warnf(t, "Unable to register metrics for Kafka producer %s", producer);
                this.tryToClose((AutoCloseable)metrics);
            }
        } else {
            this.tryToClose((AutoCloseable)metrics);
        }
    }

    void onStop(@Observes ShutdownEvent event) {
        this.clientMetrics.values().forEach(this::tryToClose);
    }

    void tryToClose(AutoCloseable c) {
        try {
            c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

