/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProviderFactory;
import org.keycloak.services.clientpolicy.executor.DPoPBindEnforcerExecutor;

public class DPoPBindEnforcerExecutorFactory
implements ClientPolicyExecutorProviderFactory {
    public static final String PROVIDER_ID = "dpop-bind-enforcer";
    public static final String AUTO_CONFIGURE = "auto-configure";
    public static final String ENFORCE_AUTHORIZATION_CODE_BINDING_TO_DPOP = "enforce-authorization-code-binding-to-dpop";
    public static final String ALLOW_ONLY_REFRESH_BINDING = "allow-only-refresh-token-binding";
    private static final ProviderConfigProperty AUTO_CONFIGURE_PROPERTY = new ProviderConfigProperty("auto-configure", "Auto-configure", "If On, then the during client creation or update, the configuration of the client will be auto-configured to use DPoP bind token", "boolean", (Object)false);
    private static final ProviderConfigProperty ENFORCE_AUTHORIZATION_CODE_BINDING_TO_DPOP_KEY = new ProviderConfigProperty("enforce-authorization-code-binding-to-dpop", "Enforce Authorization Code binding to DPoP key", "If On, then there is enforced authorization code binding to DPoP key. This means that parameter 'dpop_jkt' will be required in the OIDC/OAuth2 authentication requests and will be verified during token request if it matches DPoP proof. When this is false, it is still possible to use 'dpop_jkt' parameter, which would be checked in the token request later, but 'dpop_jkt' parameter will not be required", "boolean", (Object)false);
    private static final ProviderConfigProperty ALLOW_ONLY_REFRESH_BINDING_PROPERTY = new ProviderConfigProperty("allow-only-refresh-token-binding", "Bind only refresh token for public client", "If On and the client is public the DPoP binding is enforced only for refresh token. This option is ignored if the DPoP is enforced in client settings or if the client is not public", "boolean", (Object)false);

    public ClientPolicyExecutorProvider create(KeycloakSession session) {
        return new DPoPBindEnforcerExecutor(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "It enforces a client to enable DPoP bind token setting.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return List.of(AUTO_CONFIGURE_PROPERTY, ENFORCE_AUTHORIZATION_CODE_BINDING_TO_DPOP_KEY, ALLOW_ONLY_REFRESH_BINDING_PROPERTY);
    }
}

