/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.encoding;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.jboss.logging.Logger;
import org.keycloak.encoding.ResourceEncodingProvider;
import org.keycloak.theme.ResourceLoader;

public class GzipResourceEncodingProvider
implements ResourceEncodingProvider {
    private static final Logger logger = Logger.getLogger(ResourceEncodingProvider.class);
    private final File cacheDir;

    public GzipResourceEncodingProvider(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    @Override
    public InputStream getEncodedStream(ResourceEncodingProvider.StreamSupplier producer, String ... path) {
        try {
            File encodedFile = ResourceLoader.getFile(this.cacheDir, String.join((CharSequence)"/", path) + ".gz");
            if (encodedFile == null) {
                return null;
            }
            if (!encodedFile.exists()) {
                encodedFile = this.createEncodedFile(producer, encodedFile);
            }
            return encodedFile != null ? new FileInputStream(encodedFile) : null;
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to encode resource", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getEncoding() {
        return "gzip";
    }

    private File createEncodedFile(ResourceEncodingProvider.StreamSupplier producer, File target) throws IOException {
        InputStream is = producer.getInputStream();
        if (is == null) {
            return null;
        }
        File parent = target.getParentFile();
        if (!parent.isDirectory() && parent.mkdirs() && !parent.isDirectory()) {
            logger.warnf("Fail to create cache directory %s", (Object)parent.toString());
        }
        File tmpEncodedFile = File.createTempFile(target.getName(), "tmp", parent);
        try (InputStream inputStream = is;
             GZIPOutputStream gos = new GZIPOutputStream(new FileOutputStream(tmpEncodedFile));){
            IOUtils.copy((InputStream)is, (OutputStream)gos);
        }
        try {
            Files.move(tmpEncodedFile.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return target;
        }
        catch (IOException io) {
            logger.warnf((Throwable)io, "Fail to move temporary file to %s", (Object)target.toString());
            return null;
        }
    }
}

