/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.EnumMap;
import java.util.function.BiFunction;
import org.hibernate.Internal;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.SingleIdEntityLoaderSupport;
import org.hibernate.loader.ast.internal.SingleIdLoadPlan;
import org.hibernate.loader.ast.spi.CascadingFetchProfile;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcParametersList;

public class SingleIdEntityLoaderStandardImpl<T>
extends SingleIdEntityLoaderSupport<T> {
    private final EnumMap<LockMode, SingleIdLoadPlan<T>> selectByLockMode = new EnumMap(LockMode.class);
    private EnumMap<CascadingFetchProfile, SingleIdLoadPlan<T>> selectByInternalCascadeProfile;
    private final BiFunction<LockOptions, LoadQueryInfluencers, SingleIdLoadPlan<T>> loadPlanCreator;

    public SingleIdEntityLoaderStandardImpl(EntityMappingType entityDescriptor, LoadQueryInfluencers loadQueryInfluencers) {
        this(entityDescriptor, loadQueryInfluencers, (lockOptions, influencers) -> SingleIdEntityLoaderStandardImpl.createLoadPlan(entityDescriptor, lockOptions, influencers, influencers.getSessionFactory()));
    }

    protected SingleIdEntityLoaderStandardImpl(EntityMappingType entityDescriptor, LoadQueryInfluencers influencers, BiFunction<LockOptions, LoadQueryInfluencers, SingleIdLoadPlan<T>> loadPlanCreator) {
        super(entityDescriptor, influencers.getSessionFactory());
        this.loadPlanCreator = loadPlanCreator;
        LockOptions noLocking = new LockOptions();
        SingleIdLoadPlan<LockOptions> plan = loadPlanCreator.apply(noLocking, influencers);
        if (this.isLoadPlanReusable(noLocking, influencers)) {
            this.selectByLockMode.put(LockMode.NONE, plan);
        }
    }

    @Override
    public T load(Object key, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        return this.resolveLoadPlan(lockOptions, session.getLoadQueryInfluencers()).load(key, readOnly, true, session);
    }

    @Override
    public T load(Object key, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        return this.resolveLoadPlan(lockOptions, session.getLoadQueryInfluencers()).load(key, entityInstance, readOnly, false, session);
    }

    @Internal
    public SingleIdLoadPlan<T> resolveLoadPlan(LockOptions lockOptions, LoadQueryInfluencers influencers) {
        if (this.getLoadable().isAffectedByEnabledFilters(influencers, true)) {
            return this.loadPlanCreator.apply(lockOptions, influencers);
        }
        if (influencers.hasEnabledCascadingFetchProfile() && LockMode.PESSIMISTIC_READ.greaterThan(lockOptions.getLockMode())) {
            return this.getInternalCascadeLoadPlan(lockOptions, influencers);
        }
        return this.getRegularLoadPlan(lockOptions, influencers);
    }

    private SingleIdLoadPlan<T> getRegularLoadPlan(LockOptions lockOptions, LoadQueryInfluencers influencers) {
        if (this.isLoadPlanReusable(lockOptions, influencers)) {
            SingleIdLoadPlan<T> existing = this.selectByLockMode.get((Object)lockOptions.getLockMode());
            if (existing != null) {
                return existing;
            }
            SingleIdLoadPlan<T> plan = this.loadPlanCreator.apply(lockOptions, influencers);
            this.selectByLockMode.put(lockOptions.getLockMode(), plan);
            return plan;
        }
        return this.loadPlanCreator.apply(lockOptions, influencers);
    }

    private SingleIdLoadPlan<T> getInternalCascadeLoadPlan(LockOptions lockOptions, LoadQueryInfluencers influencers) {
        CascadingFetchProfile fetchProfile = influencers.getEnabledCascadingFetchProfile();
        if (this.selectByInternalCascadeProfile == null) {
            this.selectByInternalCascadeProfile = new EnumMap(CascadingFetchProfile.class);
        } else {
            SingleIdLoadPlan<T> existing = this.selectByInternalCascadeProfile.get((Object)fetchProfile);
            if (existing != null) {
                return existing;
            }
        }
        SingleIdLoadPlan<T> plan = this.loadPlanCreator.apply(lockOptions, influencers);
        this.selectByInternalCascadeProfile.put(fetchProfile, plan);
        return plan;
    }

    private boolean isLoadPlanReusable(LockOptions lockOptions, LoadQueryInfluencers influencers) {
        if (lockOptions.getLockMode().isPessimistic() && lockOptions.hasNonDefaultOptions()) {
            return false;
        }
        return !this.getLoadable().isAffectedByEntityGraph(influencers) && !this.getLoadable().isAffectedByEnabledFetchProfiles(influencers);
    }

    private static <T> SingleIdLoadPlan<T> createLoadPlan(EntityMappingType loadable, LockOptions lockOptions, LoadQueryInfluencers influencers, SessionFactoryImplementor factory) {
        JdbcParametersList.Builder jdbcParametersBuilder = JdbcParametersList.newBuilder();
        SelectStatement sqlAst = LoaderSelectBuilder.createSelect((Loadable)loadable, null, loadable.getIdentifierMapping(), null, 1, influencers, lockOptions, jdbcParametersBuilder::add, factory);
        return new SingleIdLoadPlan(loadable, loadable.getIdentifierMapping(), sqlAst, jdbcParametersBuilder.build(), lockOptions, factory);
    }
}

