/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.env.internal;

import java.sql.Connection;
import java.util.EnumSet;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.env.internal.BlobAndClobCreator;
import org.hibernate.engine.jdbc.env.internal.LobCreationHelper;
import org.hibernate.engine.jdbc.env.internal.LobCreationLogging;
import org.hibernate.engine.jdbc.env.internal.LobTypes;
import org.hibernate.engine.jdbc.env.internal.NonContextualLobCreator;
import org.hibernate.engine.jdbc.env.internal.StandardLobCreator;
import org.hibernate.engine.jdbc.env.spi.LobCreatorBuilder;

public class LobCreatorBuilderImpl
implements LobCreatorBuilder {
    private final boolean useConnectionToCreateLob;
    private final EnumSet<LobTypes> supportedContextualLobTypes;

    public LobCreatorBuilderImpl(boolean useConnectionToCreateLob, EnumSet<LobTypes> supportedContextualLobTypes) {
        this.useConnectionToCreateLob = useConnectionToCreateLob;
        this.supportedContextualLobTypes = supportedContextualLobTypes;
    }

    public static LobCreatorBuilderImpl makeLobCreatorBuilder(Dialect dialect, Map<String, Object> configValues, Connection jdbcConnection) {
        return new LobCreatorBuilderImpl(dialect.useConnectionToCreateLob(), LobCreationHelper.getSupportedContextualLobTypes(dialect, configValues, jdbcConnection));
    }

    public static LobCreatorBuilderImpl makeLobCreatorBuilder(Dialect dialect) {
        LobCreationLogging.LOB_MESSAGE_LOGGER.disablingContextualLOBCreationSinceConnectionNull();
        return new LobCreatorBuilderImpl(dialect.useConnectionToCreateLob(), LobCreationHelper.NONE);
    }

    @Override
    public LobCreator buildLobCreator(LobCreationContext lobCreationContext) {
        if (this.supportedContextualLobTypes.isEmpty()) {
            return NonContextualLobCreator.INSTANCE;
        }
        if (this.supportedContextualLobTypes.contains((Object)LobTypes.BLOB) && this.supportedContextualLobTypes.contains((Object)LobTypes.CLOB)) {
            if (!this.supportedContextualLobTypes.contains((Object)LobTypes.NCLOB)) {
                return new BlobAndClobCreator(lobCreationContext, this.useConnectionToCreateLob);
            }
            return new StandardLobCreator(lobCreationContext, this.useConnectionToCreateLob);
        }
        LobCreationLogging.LOB_LOGGER.debug((Object)"Unexpected condition resolving type of LobCreator to use. Falling back to NonContextualLobCreator");
        return NonContextualLobCreator.INSTANCE;
    }
}

