/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.time.Instant;
import org.hibernate.annotations.SoftDelete;
import org.hibernate.annotations.SoftDeleteType;
import org.hibernate.boot.model.convert.internal.ConverterDescriptors;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.SoftDeletable;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.mapping.SoftDeletableModelPart;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.SoftDeleteMappingImpl;

public class SoftDeleteHelper {
    public static void bindSoftDeleteIndicator(SoftDelete softDeleteConfig, SoftDeletable target, Table table, MetadataBuildingContext context) {
        assert (softDeleteConfig != null);
        BasicValue softDeleteIndicatorValue = SoftDeleteHelper.createSoftDeleteIndicatorValue(softDeleteConfig, table, context);
        Column softDeleteIndicatorColumn = SoftDeleteHelper.createSoftDeleteIndicatorColumn(softDeleteConfig, softDeleteIndicatorValue, context);
        table.addColumn(softDeleteIndicatorColumn);
        target.enableSoftDelete(softDeleteIndicatorColumn, softDeleteConfig.strategy());
    }

    private static BasicValue createSoftDeleteIndicatorValue(SoftDelete softDeleteConfig, Table table, MetadataBuildingContext context) {
        BasicValue softDeleteIndicatorValue = new BasicValue(context, table);
        softDeleteIndicatorValue.makeSoftDelete(softDeleteConfig.strategy());
        if (softDeleteConfig.strategy() == SoftDeleteType.TIMESTAMP) {
            if (softDeleteConfig.converter() != SoftDelete.UnspecifiedConversion.class) {
                throw new UnsupportedMappingException("Specifying SoftDelete#converter in conjunction with SoftDeleteType.TIMESTAMP is not supported");
            }
            softDeleteIndicatorValue.setImplicitJavaTypeAccess(typeConfiguration -> Instant.class);
        } else {
            ConverterDescriptor converterDescriptor = ConverterDescriptors.of(softDeleteConfig.converter(), context.getBootstrapContext().getClassmateContext());
            softDeleteIndicatorValue.setJpaAttributeConverterDescriptor(converterDescriptor);
            softDeleteIndicatorValue.setImplicitJavaTypeAccess(typeConfiguration -> converterDescriptor.getRelationalValueResolvedType().getErasedType());
        }
        return softDeleteIndicatorValue;
    }

    private static Column createSoftDeleteIndicatorColumn(SoftDelete softDeleteConfig, BasicValue softDeleteIndicatorValue, MetadataBuildingContext context) {
        Column softDeleteColumn = new Column();
        softDeleteColumn.setValue(softDeleteIndicatorValue);
        softDeleteIndicatorValue.addColumn(softDeleteColumn);
        SoftDeleteHelper.applyColumnName(softDeleteColumn, softDeleteConfig, context);
        softDeleteColumn.setOptions(softDeleteConfig.options());
        if (StringHelper.isBlank(softDeleteConfig.comment())) {
            softDeleteColumn.setComment("Soft-delete indicator");
        } else {
            softDeleteColumn.setComment(softDeleteConfig.comment());
        }
        softDeleteColumn.setUnique(false);
        if (softDeleteConfig.strategy() == SoftDeleteType.TIMESTAMP) {
            softDeleteColumn.setNullable(true);
        } else {
            softDeleteColumn.setLength(1);
            softDeleteColumn.setNullable(false);
        }
        return softDeleteColumn;
    }

    private static void applyColumnName(Column softDeleteColumn, SoftDelete softDeleteConfig, MetadataBuildingContext context) {
        Database database = context.getMetadataCollector().getDatabase();
        PhysicalNamingStrategy namingStrategy = context.getBuildingOptions().getPhysicalNamingStrategy();
        String logicalColumnName = StringHelper.coalesce(softDeleteConfig.strategy().getDefaultColumnName(), softDeleteConfig.columnName());
        Identifier physicalColumnName = namingStrategy.toPhysicalColumnName(database.toIdentifier(logicalColumnName), database.getJdbcEnvironment());
        softDeleteColumn.setName(physicalColumnName.render(database.getDialect()));
    }

    public static SoftDeleteMappingImpl resolveSoftDeleteMapping(SoftDeletableModelPart softDeletableModelPart, SoftDeletable bootMapping, String tableName, MappingModelCreationProcess creationProcess) {
        if (bootMapping.getSoftDeleteColumn() == null) {
            return null;
        }
        return new SoftDeleteMappingImpl(softDeletableModelPart, bootMapping, tableName, creationProcess);
    }
}

