/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.GenericLineWrapPositionStrategy;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/groovy/formatter/GrLineWrapPositionStrategy;", "Lcom/intellij/openapi/editor/GenericLineWrapPositionStrategy;", "<init>", "()V", "calculateWrapPosition", "", "document", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "startOffset", "endOffset", "maxPreferredOffset", "allowToBeyondMaxPreferredOffset", "", "isSoftWrap", "intellij.groovy"})
public final class GrLineWrapPositionStrategy
extends GenericLineWrapPositionStrategy {
    public GrLineWrapPositionStrategy() {
        this.addRule(new GenericLineWrapPositionStrategy.Rule(',', GenericLineWrapPositionStrategy.WrapCondition.AFTER));
        this.addRule(new GenericLineWrapPositionStrategy.Rule(' '));
        this.addRule(new GenericLineWrapPositionStrategy.Rule('\t'));
        this.addRule(new GenericLineWrapPositionStrategy.Rule(';', GenericLineWrapPositionStrategy.WrapCondition.AFTER));
        this.addRule(new GenericLineWrapPositionStrategy.Rule(')', GenericLineWrapPositionStrategy.WrapCondition.AFTER));
        this.addRule(new GenericLineWrapPositionStrategy.Rule('(', GenericLineWrapPositionStrategy.WrapCondition.BEFORE));
        this.addRule(new GenericLineWrapPositionStrategy.Rule('.', GenericLineWrapPositionStrategy.WrapCondition.AFTER));
    }

    public int calculateWrapPosition(@NotNull Document document, @Nullable Project project, int startOffset, int endOffset, int maxPreferredOffset, boolean allowToBeyondMaxPreferredOffset, boolean isSoftWrap) {
        int meaningfulEndOffset;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        for (meaningfulEndOffset = endOffset - 1; meaningfulEndOffset > startOffset && CharsKt.isWhitespace((char)document.getImmutableCharSequence().charAt(meaningfulEndOffset)); --meaningfulEndOffset) {
        }
        if (meaningfulEndOffset <= maxPreferredOffset) {
            return -1;
        }
        return super.calculateWrapPosition(document, project, startOffset, meaningfulEndOffset, maxPreferredOffset, allowToBeyondMaxPreferredOffset, isSoftWrap);
    }
}

