/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.xml.index.SchemaTypeInfo;
import com.intellij.xml.index.SchemaTypeInheritanceIndex;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public class SchemaDefinitionsSearch
implements QueryExecutor<PsiElement, PsiElement> {
    public boolean execute(@NotNull PsiElement queryParameters, final @NotNull Processor<? super PsiElement> consumer) {
        Collection infos;
        XmlTag xml;
        if (queryParameters == null) {
            SchemaDefinitionsSearch.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            SchemaDefinitionsSearch.$$$reportNull$$$0(1);
        }
        if (queryParameters instanceof XmlTag && ((Boolean)ReadAction.compute(() -> SchemaDefinitionsSearch.lambda$execute$0(xml = (XmlTag)queryParameters))).booleanValue() && (infos = (Collection)ReadAction.compute(() -> SchemaDefinitionsSearch.gatherInheritors(xml))) != null && !infos.isEmpty()) {
            XmlFile file = XmlUtil.getContainingFile((PsiElement)xml);
            Project project = file.getProject();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)queryParameters);
            VirtualFile vf = file.getVirtualFile();
            String thisNs = (String)ReadAction.compute(() -> XmlNamespaceIndex.getNamespace((VirtualFile)vf, (Project)project));
            String string = thisNs = thisNs == null ? SchemaDefinitionsSearch.getDefaultNs(file) : thisNs;
            if (thisNs == null) {
                return false;
            }
            ArrayList infosLst = new ArrayList(infos);
            Collections.sort(infosLst);
            HashMap nsMap = new HashMap();
            for (final SchemaTypeInfo info : infosLst) {
                HashSet<XmlFile> targetFiles = (HashSet<XmlFile>)nsMap.get(info.getNamespaceUri());
                if (targetFiles == null) {
                    targetFiles = new HashSet<XmlFile>();
                    if (Objects.equals(info.getNamespaceUri(), thisNs)) {
                        targetFiles.add(file);
                    }
                    Collection files = (Collection)ReadAction.compute(() -> XmlUtil.findNSFilesByURI((String)info.getNamespaceUri(), (Project)project, (Module)module));
                    targetFiles.addAll(files);
                    nsMap.put(info.getNamespaceUri(), targetFiles);
                }
                if (targetFiles.isEmpty()) continue;
                for (XmlFile targetFile : targetFiles) {
                    ApplicationManager.getApplication().runReadAction(() -> {
                        final String prefixByURI = XmlUtil.findNamespacePrefixByURI((XmlFile)targetFile, (String)info.getNamespaceUri());
                        if (prefixByURI == null) {
                            return;
                        }
                        PsiElementProcessor<PsiElement> processor = new PsiElementProcessor<PsiElement>(this){

                            public boolean execute(@NotNull PsiElement element) {
                                if (element == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (element instanceof XmlTag && (SchemaDefinitionsSearch.isCertainTypeElement((XmlTag)element, info.getTagName(), prefixByURI) || SchemaDefinitionsSearch.isElementWithEmbeddedType((XmlTag)element, info.getTagName(), prefixByURI))) {
                                    consumer.process((Object)element);
                                    return false;
                                }
                                return true;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/impl/schema/SchemaDefinitionsSearch$1", "execute"));
                            }
                        };
                        XmlUtil.processXmlElements((XmlElement)targetFile, (PsiElementProcessor)processor, (boolean)true);
                    });
                }
            }
        }
        return true;
    }

    public static boolean isElementWithSomeEmbeddedType(XmlTag xml) {
        XmlTag[] tags;
        String localName = xml.getLocalName();
        if (!"http://www.w3.org/2001/XMLSchema".equals(xml.getNamespace()) || !"element".equals(localName)) {
            return false;
        }
        for (XmlTag tag : tags = xml.getSubTags()) {
            if (!SchemaDefinitionsSearch.isTypeElement(tag)) continue;
            return true;
        }
        return false;
    }

    public static boolean isElementWithEmbeddedType(XmlTag xml, String typeName, String typeNsPrefix) {
        XmlTag[] tags;
        String localName = xml.getLocalName();
        if (!"http://www.w3.org/2001/XMLSchema".equals(xml.getNamespace()) || !"element".equals(localName)) {
            return false;
        }
        XmlAttribute nameAttr = SchemaDefinitionsSearch.getNameAttr(xml);
        if (nameAttr == null || nameAttr.getValue() == null) {
            return false;
        }
        String localTypeName = XmlUtil.findLocalNameByQualifiedName((String)nameAttr.getValue());
        String prefix = XmlUtil.findPrefixByQualifiedName((String)nameAttr.getValue());
        if (!typeName.equals(localTypeName) || !typeNsPrefix.equals(prefix)) {
            return false;
        }
        for (XmlTag tag : tags = xml.getSubTags()) {
            if (!SchemaDefinitionsSearch.isTypeElement(tag)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCertainTypeElement(XmlTag xml, String typeName, String nsPrefix) {
        if (!SchemaDefinitionsSearch.isTypeElement(xml)) {
            return false;
        }
        XmlAttribute name = SchemaDefinitionsSearch.getNameAttr(xml);
        if (name == null) {
            return false;
        }
        String value = name.getValue();
        if (value == null) {
            return false;
        }
        String localName = XmlUtil.findLocalNameByQualifiedName((String)value);
        return typeName.equals(localName) && nsPrefix.equals(XmlUtil.findPrefixByQualifiedName((String)value));
    }

    public static boolean isTypeElement(XmlTag xml) {
        String localName = xml.getLocalName();
        return "http://www.w3.org/2001/XMLSchema".equals(xml.getNamespace()) && ("complexType".equals(localName) || "simpleType".equals(localName));
    }

    private static Collection<SchemaTypeInfo> gatherInheritors(XmlTag xml) {
        XmlAttribute name = SchemaDefinitionsSearch.getNameAttr(xml);
        if (name == null || StringUtil.isEmptyOrSpaces((String)name.getValue())) {
            return null;
        }
        String localName = name.getValue();
        boolean hasPrefix = localName.contains(":");
        localName = hasPrefix ? localName.substring(localName.indexOf(58) + 1) : localName;
        String nsPrefix = hasPrefix ? name.getValue().substring(0, name.getValue().indexOf(58)) : null;
        XmlFile file = XmlUtil.getContainingFile((PsiElement)xml);
        if (file == null) {
            return null;
        }
        Project project = file.getProject();
        HashSet<SchemaTypeInfo> result = new HashSet<SchemaTypeInfo>();
        ArrayDeque<SchemaTypeInfo> queue = new ArrayDeque<SchemaTypeInfo>();
        String nsUri = !hasPrefix ? SchemaDefinitionsSearch.getDefaultNs(file) : XmlUtil.findNamespaceByPrefix((String)nsPrefix, (XmlTag)file.getRootTag());
        if (nsUri == null) {
            return null;
        }
        queue.add(new SchemaTypeInfo(localName, true, nsUri));
        BiFunction worker = SchemaTypeInheritanceIndex.getWorker((Project)project, (VirtualFile)file.getContainingFile().getVirtualFile());
        while (!queue.isEmpty()) {
            SchemaTypeInfo info = (SchemaTypeInfo)queue.removeFirst();
            List childrenOfType = (List)worker.apply(info.getNamespaceUri(), info.getTagName());
            for (Set infos : childrenOfType) {
                for (SchemaTypeInfo typeInfo : infos) {
                    if (typeInfo.isIsTypeName()) {
                        queue.add(typeInfo);
                    }
                    result.add(typeInfo);
                }
            }
        }
        return result;
    }

    public static XmlAttribute getNameAttr(XmlTag xml) {
        XmlAttribute name = xml.getAttribute("name", "http://www.w3.org/2001/XMLSchema");
        name = name == null ? xml.getAttribute("name") : name;
        return name;
    }

    private static String getDefaultNs(XmlFile file) {
        return (String)ReadAction.compute(() -> {
            XmlTag tag = file.getDocument().getRootTag();
            XmlAttribute xmlns = tag.getAttribute("xmlns", "http://www.w3.org/2001/XMLSchema");
            xmlns = xmlns == null ? tag.getAttribute("xmlns") : xmlns;
            String nsUri = xmlns == null ? null : xmlns.getValue();
            return nsUri;
        });
    }

    private static /* synthetic */ Boolean lambda$execute$0(XmlTag xml) throws RuntimeException {
        return SchemaDefinitionsSearch.isTypeElement(xml);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/xml/impl/schema/SchemaDefinitionsSearch";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

