/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.impl.shared.ui;

import com.intellij.idea.AppModeAssertions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.platform.vcs.impl.shared.CaseSensitivityInfoHolder;
import com.intellij.platform.vcs.impl.shared.VcsMappingsHolder;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007J$\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\tH\u0007J$\u0010\u000e\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\tH\u0007J,\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J/\u0010\u0011\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010\u0014\u001a\u000e\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00122\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\tH\u0002J\u001a\u0010\u0017\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\r\u001a\u00020\tH\u0002J\u001a\u0010\u0018\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/vcs/impl/shared/ui/VcsPresentablePath;", "", "<init>", "()V", "getPresentablePath", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/SystemDependent;", "parentPath", "Lcom/intellij/openapi/vcs/FilePath;", "path", "project", "Lcom/intellij/openapi/project/Project;", "filePath", "getPresentablePathAsParent", "acceptEmptyPath", "", "getRootRelativePath", "Lorg/jetbrains/annotations/SystemIndependent;", "projectBaseDir", "getRelativePathIfSuccessor", "ancestor", "shouldHandleAsNonLocal", "getRelativePathToUserHome", "getSystemDependentPath", "intellij.platform.vcs.impl.shared"})
public final class VcsPresentablePath {
    @NotNull
    public static final VcsPresentablePath INSTANCE = new VcsPresentablePath();

    private VcsPresentablePath() {
    }

    @JvmStatic
    @NotNull
    public static final String getPresentablePath(@NotNull FilePath parentPath, @NotNull FilePath path) {
        Intrinsics.checkNotNullParameter((Object)parentPath, (String)"parentPath");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = parentPath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String string2 = path.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        String string3 = INSTANCE.getRelativePathIfSuccessor(string, string2);
        if (string3 == null) {
            String string4 = path.getPath();
            string3 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
        }
        String prettyPath = string3;
        return INSTANCE.shouldHandleAsNonLocal(path) ? prettyPath : INSTANCE.getSystemDependentPath(prettyPath);
    }

    @JvmStatic
    @NotNull
    public static final String getPresentablePath(@Nullable Project project, @NotNull FilePath filePath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (INSTANCE.shouldHandleAsNonLocal(filePath)) {
            String string2 = filePath.getPath();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        } else {
            string = INSTANCE.getPresentablePath(project, filePath, false);
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String getPresentablePathAsParent(@Nullable Project project, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return INSTANCE.getPresentablePath(project, filePath, true);
    }

    private final String getPresentablePath(Project project, FilePath filePath, boolean acceptEmptyPath) {
        String projectDir;
        Project project2 = project;
        String string = projectDir = project2 != null ? project2.getBasePath() : null;
        if (projectDir != null) {
            String rootRelativePath = this.getRootRelativePath(project, projectDir, filePath, acceptEmptyPath);
            if (rootRelativePath != null) {
                return this.getSystemDependentPath(rootRelativePath);
            }
            String string2 = filePath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            String projectRelativePath = this.getRelativePathIfSuccessor(projectDir, string2);
            if (projectRelativePath != null) {
                Object[] objectArray = new Object[]{projectRelativePath};
                String string3 = VcsBundle.message((String)"label.relative.project.path.presentation", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                return this.getSystemDependentPath(string3);
            }
        }
        return this.getRelativePathToUserHome(filePath);
    }

    private final String getRootRelativePath(Project project, String projectBaseDir, FilePath filePath, boolean acceptEmptyPath) {
        if (project.isDisposed()) {
            return null;
        }
        String string = filePath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String path = string;
        VcsMappingsHolder vcsMappingsHolder = VcsMappingsHolder.Companion.getInstance(project);
        FilePath filePath2 = vcsMappingsHolder.getRootFor(filePath);
        if (filePath2 == null) {
            return null;
        }
        FilePath root = filePath2;
        String string2 = root.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        String rootPath = string2;
        List<FilePath> roots = vcsMappingsHolder.getAllRoots();
        if (roots.size() == 1) {
            if (Intrinsics.areEqual((Object)rootPath, (Object)path)) {
                return acceptEmptyPath ? "" : root.getName();
            }
            return this.getRelativePathIfSuccessor(rootPath, path);
        }
        if (Intrinsics.areEqual((Object)projectBaseDir, (Object)path)) {
            return root.getName();
        }
        String string3 = this.getRelativePathIfSuccessor(projectBaseDir, path);
        if (string3 == null) {
            return null;
        }
        String relativePath = string3;
        return Intrinsics.areEqual((Object)projectBaseDir, (Object)rootPath) ? root.getName() + "/" + relativePath : relativePath;
    }

    private final String getRelativePathIfSuccessor(String ancestor, String path) {
        return FileUtil.getRelativePath((String)ancestor, (String)path, (char)'/', (boolean)CaseSensitivityInfoHolder.INSTANCE.getCaseSensitive());
    }

    private final boolean shouldHandleAsNonLocal(FilePath filePath) {
        return AppModeAssertions.isMonolith() && filePath.isNonLocal();
    }

    private final String getRelativePathToUserHome(FilePath filePath) {
        String string;
        if (AppModeAssertions.isMonolith()) {
            String string2 = filePath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            String string3 = FileUtil.getLocationRelativeToUserHome((String)this.getSystemDependentPath(string2));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLocationRelativeToUserHome(...)");
        } else {
            String string4 = filePath.getPath();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
        }
        return string;
    }

    private final String getSystemDependentPath(String path) {
        String string;
        if (AppModeAssertions.isMonolith()) {
            String string2 = FileUtil.toSystemDependentName((String)path);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
        } else {
            string = path;
        }
        return string;
    }
}

