/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.serialization.kotlinx;

import io.ktor.serialization.WebsocketContentConverter;
import io.ktor.serialization.WebsocketConverterNotFoundException;
import io.ktor.serialization.WebsocketDeserializeException;
import io.ktor.serialization.kotlinx.SerializerLookupKt;
import io.ktor.util.reflect.TypeInfo;
import io.ktor.websocket.Frame;
import io.ktor.websocket.FrameCommonKt;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\u000e\u001a\u00020\r2\n\u0010\b\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\n\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0096@\u00a2\u0006\u0004\b\u000e\u0010\u000fJ.\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\n\u0010\b\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\rH\u0096@\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J-\u0010\u0019\u001a\u00020\r2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lio/ktor/serialization/kotlinx/KotlinxWebsocketSerializationConverter;", "Lio/ktor/serialization/WebsocketContentConverter;", "Lkotlinx/serialization/SerialFormat;", "format", "<init>", "(Lkotlinx/serialization/SerialFormat;)V", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "charset", "Lio/ktor/util/reflect/TypeInfo;", "typeInfo", "", "value", "Lio/ktor/websocket/Frame;", "serialize", "(Ljava/nio/charset/Charset;Lio/ktor/util/reflect/TypeInfo;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "content", "deserialize", "(Ljava/nio/charset/Charset;Lio/ktor/util/reflect/TypeInfo;Lio/ktor/websocket/Frame;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "frame", "", "isApplicable", "(Lio/ktor/websocket/Frame;)Z", "Lkotlinx/serialization/KSerializer;", "serializer", "serializeContent", "(Lkotlinx/serialization/KSerializer;Lkotlinx/serialization/SerialFormat;Ljava/lang/Object;)Lio/ktor/websocket/Frame;", "Lkotlinx/serialization/SerialFormat;", "ktor-serialization-kotlinx"})
public final class KotlinxWebsocketSerializationConverter
implements WebsocketContentConverter {
    @NotNull
    private final SerialFormat format;

    public KotlinxWebsocketSerializationConverter(@NotNull SerialFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.format = format;
        if (!(this.format instanceof BinaryFormat || this.format instanceof StringFormat)) {
            boolean bl = false;
            String string = "Only binary and string formats are supported, " + this.format + " is not supported.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Charset charset, @NotNull TypeInfo typeInfo, @Nullable Object value, @NotNull Continuation<? super Frame> $completion) {
        Object object;
        try {
            object = SerializerLookupKt.serializerForTypeInfo(this.format.getSerializersModule(), typeInfo);
        }
        catch (SerializationException cause) {
            object = SerializerLookupKt.guessSerializer(value, this.format.getSerializersModule());
        }
        Object serializer2 = object;
        return this.serializeContent((KSerializer<?>)serializer2, this.format, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Object deserialize(@NotNull Charset charset, @NotNull TypeInfo typeInfo, @NotNull Frame content2, @NotNull Continuation<Object> $completion) {
        Object object;
        if (!this.isApplicable(content2)) {
            throw new WebsocketConverterNotFoundException("Unsupported frame " + content2.getFrameType().name(), null, 2, null);
        }
        KSerializer<?> serializer2 = SerializerLookupKt.serializerForTypeInfo(this.format.getSerializersModule(), typeInfo);
        SerialFormat serialFormat = this.format;
        if (serialFormat instanceof StringFormat) {
            if (!(content2 instanceof Frame.Text)) throw new WebsocketDeserializeException("Unsupported format " + this.format + " for " + content2.getFrameType().name(), null, content2, 2, null);
            object = ((StringFormat)this.format).decodeFromString((DeserializationStrategy)serializer2, FrameCommonKt.readText((Frame.Text)content2));
            return object;
        } else {
            if (!(serialFormat instanceof BinaryFormat)) throw new IllegalStateException(("Unsupported format " + this.format).toString());
            if (!(content2 instanceof Frame.Binary)) throw new WebsocketDeserializeException("Unsupported format " + this.format + " for " + content2.getFrameType().name(), null, content2, 2, null);
            object = ((BinaryFormat)this.format).decodeFromByteArray((DeserializationStrategy)serializer2, FrameCommonKt.readBytes(content2));
        }
        return object;
    }

    @Override
    public boolean isApplicable(@NotNull Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        return frame instanceof Frame.Text || frame instanceof Frame.Binary;
    }

    private final Frame serializeContent(KSerializer<?> serializer2, SerialFormat format, Object value) {
        Frame frame;
        SerialFormat serialFormat = format;
        if (serialFormat instanceof StringFormat) {
            StringFormat stringFormat = (StringFormat)format;
            Intrinsics.checkNotNull(serializer2, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any?>");
            String content2 = stringFormat.encodeToString((SerializationStrategy)serializer2, value);
            frame = new Frame.Text(content2);
        } else if (serialFormat instanceof BinaryFormat) {
            BinaryFormat binaryFormat = (BinaryFormat)format;
            Intrinsics.checkNotNull(serializer2, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any?>");
            byte[] content3 = binaryFormat.encodeToByteArray((SerializationStrategy)serializer2, value);
            frame = new Frame.Binary(true, content3);
        } else {
            throw new IllegalStateException(("Unsupported format " + format).toString());
        }
        return frame;
    }
}

