/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleModuleDataKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000b2\b\b\u0002\u0010'\u001a\u00020\"H\u0007J\u0015\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\b(J \u0010)\u001a\b\u0012\u0004\u0012\u0002H+0*\"\u0004\b\u0000\u0010+2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H+0-J!\u0010.\u001a\u0004\u0018\u0001H+\"\u0004\b\u0000\u0010+2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H+0-\u00a2\u0006\u0002\u0010/R\u0016\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00070\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000eR\u001a\u0010\u0017\u001a\u00020\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u000eR\u001a\u0010\u001b\u001a\u00020\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001c\u0010\u0019\u001a\u0004\b\u001d\u0010\u000eR\u001a\u0010\u001e\u001a\u00020\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001f\u0010\u0019\u001a\u0004\b \u0010\u000eR\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010#R\u0011\u0010$\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010#\u00a8\u00060"}, d2={"Lorg/jetbrains/plugins/gradle/util/GradleModuleData;", "", "dataNode", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "<init>", "(Lcom/intellij/openapi/externalSystem/model/DataNode;)V", "moduleData", "getModuleData", "()Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "moduleName", "", "Lorg/jetbrains/annotations/NotNull;", "getModuleName", "()Ljava/lang/String;", "gradleProjectDir", "getGradleProjectDir", "directoryToRunTask", "getDirectoryToRunTask", "gradlePathOrNull", "getGradlePathOrNull", "gradleIdentityPathOrNull", "getGradleIdentityPathOrNull", "gradlePath", "getGradlePath$annotations", "()V", "getGradlePath", "gradleIdentityPath", "getGradleIdentityPath$annotations", "getGradleIdentityPath", "fullGradlePath", "getFullGradlePath$annotations", "getFullGradlePath", "isBuildSrcModule", "", "()Z", "isIncludedBuild", "getTaskPath", "simpleTaskName", "prependCompositeBuildPath", "getTaskPathOfSimpleTaskName", "findAll", "", "T", "key", "Lcom/intellij/openapi/externalSystem/model/Key;", "find", "(Lcom/intellij/openapi/externalSystem/model/Key;)Ljava/lang/Object;", "intellij.gradle"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nGradleModuleData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleModuleData.kt\norg/jetbrains/plugins/gradle/util/GradleModuleData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1#2:124\n1#2:135\n1617#3,9:125\n1869#3:134\n1870#3:136\n1626#3:137\n*S KotlinDebug\n*F\n+ 1 GradleModuleData.kt\norg/jetbrains/plugins/gradle/util/GradleModuleData\n*L\n73#1:135\n73#1:125,9\n73#1:134\n73#1:136\n73#1:137\n*E\n"})
public final class GradleModuleData {
    @NotNull
    private final DataNode<? extends ModuleData> dataNode;
    @NotNull
    private final ModuleData moduleData;
    @NotNull
    private final String moduleName;
    @NotNull
    private final String gradleProjectDir;

    public GradleModuleData(@NotNull DataNode<? extends ModuleData> dataNode) {
        Intrinsics.checkNotNullParameter(dataNode, (String)"dataNode");
        this.dataNode = dataNode;
        Object object = this.dataNode.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        this.moduleData = (ModuleData)object;
        ProjectSystemId projectSystemId = this.moduleData.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"getOwner(...)");
        ProjectSystemId systemId = projectSystemId;
        if (!Intrinsics.areEqual((Object)systemId, (Object)GradleConstants.SYSTEM_ID)) {
            boolean bl = false;
            String string = "Gradle module expected but '" + systemId + "' module has been got.";
            throw new IllegalArgumentException(string.toString());
        }
        String string = this.moduleData.getModuleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getModuleName(...)");
        this.moduleName = string;
        String string2 = this.moduleData.getLinkedExternalProjectPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLinkedExternalProjectPath(...)");
        this.gradleProjectDir = string2;
    }

    @NotNull
    public final ModuleData getModuleData() {
        return this.moduleData;
    }

    @NotNull
    public final String getModuleName() {
        return this.moduleName;
    }

    @NotNull
    public final String getGradleProjectDir() {
        return this.gradleProjectDir;
    }

    @NotNull
    public final String getDirectoryToRunTask() {
        return GradleModuleDataKt.getDirectoryToRunTask(this.moduleData);
    }

    @Nullable
    public final String getGradlePathOrNull() {
        return GradleModuleDataKt.getGradlePathOrNull(this.moduleData);
    }

    @Nullable
    public final String getGradleIdentityPathOrNull() {
        return GradleModuleDataKt.getGradleIdentityPathOrNull(this.moduleData);
    }

    @NotNull
    public final String getGradlePath() {
        return GradleModuleDataKt.getGradlePath(this.moduleData);
    }

    @Deprecated(message="Use gradlePathOrNull instead")
    public static /* synthetic */ void getGradlePath$annotations() {
    }

    @NotNull
    public final String getGradleIdentityPath() {
        return GradleModuleDataKt.getGradleIdentityPath(this.moduleData);
    }

    @Deprecated(message="Use gradleIdentityPathOrNull instead")
    public static /* synthetic */ void getGradleIdentityPath$annotations() {
    }

    @NotNull
    public final String getFullGradlePath() {
        return this.getGradleIdentityPath();
    }

    @Deprecated(message="Use gradleIdentityPathOrNull instead")
    public static /* synthetic */ void getFullGradlePath$annotations() {
    }

    public final boolean isBuildSrcModule() {
        return GradleModuleDataKt.isBuildSrcModule(this.moduleData);
    }

    public final boolean isIncludedBuild() {
        return GradleModuleDataKt.isIncludedBuild(this.moduleData);
    }

    @Deprecated(message="Use 'getTaskPath(String) instead")
    @NotNull
    public final String getTaskPath(@NotNull String simpleTaskName, boolean prependCompositeBuildPath) {
        Intrinsics.checkNotNullParameter((Object)simpleTaskName, (String)"simpleTaskName");
        return this.getTaskPathOfSimpleTaskName(simpleTaskName);
    }

    public static /* synthetic */ String getTaskPath$default(GradleModuleData gradleModuleData, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return gradleModuleData.getTaskPath(string, bl);
    }

    @JvmName(name="getTaskPathOfSimpleTaskName")
    @NotNull
    public final String getTaskPathOfSimpleTaskName(@NotNull String simpleTaskName) {
        Intrinsics.checkNotNullParameter((Object)simpleTaskName, (String)"simpleTaskName");
        String identityPath = GradleModuleDataKt.getGradleIdentityPath(this.moduleData);
        return ((CharSequence)identityPath).length() == 0 || Intrinsics.areEqual((Object)identityPath, (Object)":") ? ":" + simpleTaskName : identityPath + ":" + simpleTaskName;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> Collection<T> findAll(@NotNull Key<T> key) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Collection collection = ExternalSystemApiUtil.findAll(this.dataNode, key);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findAll(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DataNode it = (DataNode)element$iv$iv;
            boolean bl2 = false;
            if (it.getData() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final <T> T find(@NotNull Key<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        DataNode dataNode = ExternalSystemApiUtil.find(this.dataNode, key);
        return (T)(dataNode != null ? dataNode.getData() : null);
    }
}

