/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions.generate;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.util.GroovyChangeContextUtil;

public class GroovyGenerationInfo<T extends PsiMember>
extends PsiGenerationInfo<T> {
    private static final Logger LOG = Logger.getInstance(GroovyGenerationInfo.class);

    public GroovyGenerationInfo(@NotNull T member, boolean mergeIfExists) {
        if (member == null) {
            GroovyGenerationInfo.$$$reportNull$$$0(0);
        }
        super(member, mergeIfExists);
    }

    public GroovyGenerationInfo(@NotNull T member) {
        if (member == null) {
            GroovyGenerationInfo.$$$reportNull$$$0(1);
        }
        super(member);
    }

    public void insert(@NotNull PsiClass aClass, @Nullable PsiElement anchor, boolean before) throws IncorrectOperationException {
        PsiMember proto;
        if (aClass == null) {
            GroovyGenerationInfo.$$$reportNull$$$0(2);
        }
        if ((proto = this.getPsiMember()) instanceof GrMethod) {
            GroovyChangeContextUtil.encodeContextInfo(((GrMethod)proto).getParameterList());
        }
        super.insert(aClass, anchor, before);
        PsiMember member = this.getPsiMember();
        if (member == null) {
            return;
        }
        LOG.assertTrue(member instanceof GroovyPsiElement, (Object)member);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(member.getProject());
        PsiElement prev = member.getPrevSibling();
        if (prev != null && GroovyTokenTypes.mNLS == prev.getNode().getElementType()) {
            prev.replace(factory.createLineTerminator(1));
        } else if (prev instanceof PsiMember) {
            member.getParent().getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", member.getNode());
        }
        PsiElement next = member.getNextSibling();
        if (next != null && GroovyTokenTypes.mNLS == next.getNode().getElementType()) {
            next.replace(factory.createLineTerminator(1));
        } else if (next instanceof PsiMember) {
            member.getParent().getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", next.getNode());
        }
        if (member instanceof GrMethod) {
            GroovyChangeContextUtil.decodeContextInfo(((GrMethod)member).getParameterList(), null, null);
        }
        JavaCodeStyleManager.getInstance((Project)member.getProject()).shortenClassReferences((PsiElement)member);
        GroovyGenerationInfo.adjustDocCommentIfExists(member);
    }

    private static void adjustDocCommentIfExists(PsiMember member) {
        PsiElement child = member.getFirstChild();
        if (child instanceof PsiDocComment) {
            Project project = member.getProject();
            GrDocComment groovyDoc = GroovyPsiElementFactory.getInstance(project).createDocCommentFromText(child.getText());
            child.delete();
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)member);
            member.getParent().addBefore((PsiElement)groovyDoc, (PsiElement)member);
        }
    }

    public PsiElement findInsertionAnchor(@NotNull PsiClass aClass, @NotNull PsiElement leaf) {
        Object parent;
        if (aClass == null) {
            GroovyGenerationInfo.$$$reportNull$$$0(3);
        }
        if (leaf == null) {
            GroovyGenerationInfo.$$$reportNull$$$0(4);
        }
        Object object = parent = aClass instanceof GroovyScriptClass ? aClass.getContainingFile() : ((GrTypeDefinition)aClass).getBody();
        if (parent == null) {
            return null;
        }
        if (!PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)leaf, (boolean)true)) {
            return null;
        }
        PsiElement element = PsiTreeUtil.findPrevParent((PsiElement)parent, (PsiElement)leaf);
        PsiElement lBrace = aClass.getLBrace();
        if (lBrace == null) {
            return null;
        }
        PsiElement rBrace = aClass.getRBrace();
        if (!GenerateMembersUtil.isChildInRange((PsiElement)element, (PsiElement)lBrace.getNextSibling(), (PsiElement)rBrace)) {
            return null;
        }
        return element;
    }

    public void positionCaret(@NotNull Editor editor, boolean toEditMethodBody) {
        GrMethod method;
        GrOpenBlock body;
        GrMethod method2;
        GrOpenBlock body2;
        PsiMember firstMember;
        if (editor == null) {
            GroovyGenerationInfo.$$$reportNull$$$0(5);
        }
        LOG.assertTrue((firstMember = this.getPsiMember()) != null);
        if (toEditMethodBody && (body2 = (method2 = (GrMethod)firstMember).getBlock()) != null) {
            PsiElement r;
            PsiElement l = body2.getLBrace();
            if (l != null) {
                l = l.getNextSibling();
            }
            while (PsiImplUtil.isWhiteSpaceOrNls(l)) {
                l = l.getNextSibling();
            }
            if (l == null) {
                l = body2;
            }
            if ((r = body2.getRBrace()) != null) {
                r = r.getPrevSibling();
            }
            while (PsiImplUtil.isWhiteSpaceOrNls(r)) {
                r = r.getPrevSibling();
            }
            if (r == null) {
                r = body2;
            }
            int start = l.getTextRange().getStartOffset();
            int end = r.getTextRange().getEndOffset();
            editor.getCaretModel().moveToOffset(Math.min(start, end));
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            if (start < end) {
                editor.getSelectionModel().setSelection(start, end);
            }
            return;
        }
        int offset = firstMember instanceof GrMethod ? ((body = (method = (GrMethod)firstMember).getBlock()) == null ? method.getTextRange().getStartOffset() : body.getLBrace().getTextRange().getEndOffset()) : firstMember.getTextRange().getStartOffset();
        editor.getCaretModel().moveToOffset(offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/actions/generate/GroovyGenerationInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "insert";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findInsertionAnchor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "positionCaret";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

