/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.groovy;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Map;
import org.intellij.plugins.intelliLang.util.ContextComputationProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCallReference;

public final class GrInjectionUtil {
    static int findParameterIndex(PsiElement arg, GrCall call) {
        GroovyResolveResult result2 = call.advancedResolve();
        PsiElement psiElement = result2.getElement();
        if (!(psiElement instanceof PsiMethod)) {
            return -1;
        }
        PsiMethod method = (PsiMethod)psiElement;
        Map<GrExpression, Pair<PsiParameter, PsiType>> map2 = GrClosureSignatureUtil.mapArgumentsToParameters(result2, call, false, false, call.getNamedArguments(), call.getExpressionArguments(), call.getClosureArguments());
        if (map2 == null) {
            return -1;
        }
        PsiParameter parameter = (PsiParameter)map2.get((Object)arg).first;
        if (parameter == null) {
            return -1;
        }
        return method.getParameterList().getParameterIndex(parameter);
    }

    @Nullable
    static PsiMethod getMethodFromLeftShiftOperator(@NotNull GrBinaryExpression expression) {
        IElementType operator;
        if (expression == null) {
            GrInjectionUtil.$$$reportNull$$$0(0);
        }
        if ((operator = expression.getOperator()) != GroovyElementTypes.LEFT_SHIFT_SIGN) {
            return null;
        }
        GroovyCallReference reference = expression.getReference();
        if (reference == null) {
            return null;
        }
        PsiElement resolvedElement = reference.resolve();
        if (!(resolvedElement instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)resolvedElement;
        return method;
    }

    @Nullable
    static PsiParameter getSingleParameterFromMethod(@Nullable PsiMethod method) {
        if (method == null) {
            return null;
        }
        PsiParameterList parameterList = method.getParameterList();
        return (PsiParameter)ContainerUtil.getOnlyItem(Arrays.asList(parameterList.getParameters()));
    }

    public static void visitAnnotatedElements(@Nullable PsiElement element, AnnotatedElementVisitor visitor2) {
        if (element == null) {
            return;
        }
        for (PsiElement cur = ContextComputationProcessor.getTopLevelInjectionTarget((PsiElement)element); cur != null; cur = cur.getParent()) {
            if (GrInjectionUtil.visitAnnotatedElementInner(cur, visitor2)) continue;
            return;
        }
    }

    private static boolean visitAnnotatedElementInner(PsiElement element, AnnotatedElementVisitor visitor2) {
        PsiElement parent = element.getParent();
        if (element instanceof GrReferenceExpression) {
            if (!visitor2.visitReference((GrReferenceExpression)element)) {
                return false;
            }
        } else if (element instanceof GrAnnotationNameValuePair && parent != null && parent.getParent() instanceof PsiAnnotation) {
            return visitor2.visitAnnotationParameter((GrAnnotationNameValuePair)element, (PsiAnnotation)parent.getParent());
        }
        if (parent instanceof GrAssignmentExpression) {
            GrExpression left;
            GrAssignmentExpression p = (GrAssignmentExpression)parent;
            if ((p.getRValue() == element || p.getOperationTokenType() == GroovyTokenTypes.mPLUS_ASSIGN) && (left = p.getLValue()) instanceof GrReferenceExpression && !visitor2.visitReference((GrReferenceExpression)left)) {
                return false;
            }
        } else {
            if (parent instanceof GrConditionalExpression && ((GrConditionalExpression)parent).getCondition() == element) {
                return false;
            }
            if (parent instanceof GrReturnStatement) {
                PsiElement m = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiMethod.class, GrClosableBlock.class, GroovyFile.class});
                if (m instanceof PsiMethod && !visitor2.visitMethodReturnStatement((GrReturnStatement)parent, (PsiMethod)m)) {
                    return false;
                }
            } else {
                if (parent instanceof PsiVariable) {
                    return visitor2.visitVariable((PsiVariable)parent);
                }
                if (parent instanceof PsiModifierListOwner) {
                    return false;
                }
                if (parent instanceof GrAnnotationArrayInitializer || parent instanceof GrAnnotationNameValuePair) {
                    return true;
                }
                if (parent instanceof GrBinaryExpression) {
                    GrBinaryExpression binaryExpression = (GrBinaryExpression)parent;
                    return visitor2.visitBinaryExpression(binaryExpression);
                }
                if (parent instanceof GrArgumentList && parent.getParent() instanceof GrCall && element instanceof GrExpression) {
                    return visitor2.visitMethodParameter((GrExpression)element, (GrCall)parent.getParent());
                }
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/intellij/plugins/intelliLang/inject/groovy/GrInjectionUtil", "getMethodFromLeftShiftOperator"));
    }

    public static interface AnnotatedElementVisitor {
        public boolean visitMethodParameter(@NotNull GrExpression var1, @NotNull GrCall var2);

        public boolean visitMethodReturnStatement(@NotNull GrReturnStatement var1, @NotNull PsiMethod var2);

        public boolean visitVariable(@NotNull PsiVariable var1);

        public boolean visitAnnotationParameter(@NotNull GrAnnotationNameValuePair var1, @NotNull PsiAnnotation var2);

        public boolean visitReference(@NotNull GrReferenceExpression var1);

        public boolean visitBinaryExpression(@NotNull GrBinaryExpression var1);
    }
}

