/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.struct;

import ghidra.pcode.struct.BlockStmt;
import ghidra.pcode.struct.StringTree;
import ghidra.pcode.struct.StructuredSleigh;
import ghidra.program.model.data.DataType;

class RoutineStmt
extends BlockStmt {
    protected final String name;
    protected final DataType retType;
    protected StructuredSleigh.Label lReturn;

    protected RoutineStmt(StructuredSleigh ctx, String name, DataType retType, Runnable body) {
        super(ctx, body);
        this.name = name;
        this.retType = retType;
    }

    @Override
    protected StringTree generate(StructuredSleigh.Label next, StructuredSleigh.Label fall) {
        if (this.children.isEmpty()) {
            return StringTree.single("");
        }
        StructuredSleigh.Label lExit = this.lReturn = next.freshOrBorrow();
        StringTree blockGen = super.generate(this.lReturn, lExit);
        StringTree st = new StringTree();
        st.append(blockGen);
        st.append(lExit.genAnchor());
        return st;
    }
}

