/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.constantpool;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ConstantPoolStringInfo
extends AbstractConstantPoolInfoJava {
    private short stringIndex;

    public ConstantPoolStringInfo(BinaryReader reader) throws IOException {
        super(reader);
        this.stringIndex = reader.readNextShort();
    }

    public int getStringIndex() {
        return this.stringIndex & 0xFFFF;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "CONSTANT_String_info";
        StructureDataType structure = new StructureDataType(name, 0);
        structure.add(BYTE, "tag", null);
        structure.add(WORD, "string_index", null);
        return structure;
    }
}

