/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.protocol.BSimQuery;
import ghidra.features.bsim.query.protocol.ResponseNearestVector;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class QueryNearestVector
extends BSimQuery<ResponseNearestVector> {
    public DescriptionManager manage = new DescriptionManager();
    public ResponseNearestVector nearresponse;
    public double thresh = 0.7;
    public double signifthresh = 0.0;
    public int vectormax = 0;

    public QueryNearestVector() {
        super("querynearestvector");
    }

    @Override
    public void buildResponseTemplate() {
        if (this.response == null) {
            this.nearresponse = new ResponseNearestVector(this);
            this.response = this.nearresponse;
        }
    }

    @Override
    public DescriptionManager getDescriptionManager() {
        return this.manage;
    }

    public QueryNearestVector getLocalStagingCopy() {
        QueryNearestVector newq = new QueryNearestVector();
        newq.thresh = this.thresh;
        newq.signifthresh = this.signifthresh;
        newq.vectormax = this.vectormax;
        return newq;
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append('<').append(this.name).append(">\n");
        this.manage.saveXml(fwrite);
        fwrite.append("<simthresh>").append(Double.toString(this.thresh)).append("</simthresh>\n");
        fwrite.append("<signifthresh>").append(Double.toString(this.signifthresh)).append("</signifthresh>\n");
        if (this.vectormax != 0) {
            fwrite.append("<vectormax>").append(SpecXmlUtils.encodeSignedInteger((long)this.vectormax)).append("</vectormax>\n");
        }
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        this.vectormax = 0;
        parser.start(new String[]{this.name});
        this.manage.restoreXml(parser, vectorFactory);
        parser.start(new String[]{"simthresh"});
        this.thresh = Double.parseDouble(parser.end().getText());
        parser.start(new String[]{"signifthresh"});
        this.signifthresh = Double.parseDouble(parser.end().getText());
        while (parser.peek().isStart()) {
            XmlElement el = parser.start(new String[0]);
            if (el.getName().equals("vectormax")) {
                this.vectormax = SpecXmlUtils.decodeInt((String)parser.end().getText());
                continue;
            }
            throw new LSHException("Unknown tag: " + el.getName());
        }
        parser.end();
    }
}

