/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.protocol.BSimQuery;
import ghidra.features.bsim.query.protocol.ResponseCluster;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class QueryCluster
extends BSimQuery<ResponseCluster> {
    public final DescriptionManager manage = new DescriptionManager();
    public ResponseCluster clusterresponse;
    public double thresh = 0.9;
    public double signifthresh = 0.0;
    public int vectormax = 50;

    public QueryCluster() {
        super("querycluster");
    }

    @Override
    public void buildResponseTemplate() {
        if (this.response == null) {
            this.clusterresponse = new ResponseCluster(this);
            this.response = this.clusterresponse;
        }
    }

    @Override
    public DescriptionManager getDescriptionManager() {
        return this.manage;
    }

    public QueryCluster getLocalStagingCopy() {
        QueryCluster newc = new QueryCluster();
        newc.thresh = this.thresh;
        newc.signifthresh = this.signifthresh;
        newc.vectormax = this.vectormax;
        return newc;
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append('<').append(this.name).append(">\n");
        this.manage.saveXml(fwrite);
        fwrite.append("<simthresh>").append(Double.toString(this.thresh)).append("</simthresh>\n");
        fwrite.append("<signifthresh>").append(Double.toString(this.signifthresh)).append("</signifthresh>\n");
        fwrite.append("<max>").append(SpecXmlUtils.encodeSignedInteger((long)this.vectormax)).append("</max>\n");
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        parser.start(new String[]{this.name});
        this.manage.restoreXml(parser, vectorFactory);
        parser.start(new String[]{"simthresh"});
        this.thresh = Double.parseDouble(parser.end().getText());
        parser.start(new String[]{"signifthresh"});
        this.signifthresh = Double.parseDouble(parser.end().getText());
        parser.start(new String[]{"max"});
        this.vectormax = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.end();
    }
}

