/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.AbstractElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.eBPF_ElfRelocationType;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;

public class eBPF_ElfRelocationHandler
extends AbstractElfRelocationHandler<eBPF_ElfRelocationType, ElfRelocationContext<?>> {
    public eBPF_ElfRelocationHandler() {
        super(eBPF_ElfRelocationType.class);
    }

    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 247;
    }

    protected RelocationResult relocate(ElfRelocationContext<?> elfRelocationContext, ElfRelocation relocation, eBPF_ElfRelocationType type, Address relocationAddress, ElfSymbol symbol, Address symbolAddr, long symbolValue, String symbolName) throws MemoryAccessException {
        int byteLength;
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        ElfSectionHeader sectionToBeRelocated = elfRelocationContext.relocationTable.getSectionToBeRelocated();
        if (sectionToBeRelocated != null && sectionToBeRelocated.getNameAsString().startsWith(".debug")) {
            return RelocationResult.SKIPPED;
        }
        if (this.handleUnresolvedSymbol(elfRelocationContext, relocation, relocationAddress)) {
            return RelocationResult.FAILURE;
        }
        switch (type) {
            case R_BPF_64_64: {
                byteLength = 12;
                long new_value = symbolAddr.getAddressableWordOffset();
                Byte dst = memory.getByte(relocationAddress.add(1L));
                memory.setLong(relocationAddress.add(4L), new_value);
                memory.setByte(relocationAddress.add(1L), (byte)(dst + 16));
                break;
            }
            case R_BPF_64_32: {
                byteLength = 8;
                long instr_next = relocationAddress.add(8L).getAddressableWordOffset();
                if (symbol.isFunction()) {
                    long new_value = symbolAddr.getAddressableWordOffset();
                    int offset = (int)((new_value - instr_next) / 8L);
                    memory.setInt(relocationAddress.add(4L), offset);
                    break;
                }
                if (!symbol.isSection() || memory.getInt(relocationAddress) != 4229) break;
                ElfSectionHeader sectionHeader = elfRelocationContext.getElfHeader().getSection(symbolName);
                long section_start = program.getImageBase().getOffset() + sectionHeader.getAddress();
                int current_imm = memory.getInt(relocationAddress.add(4L));
                int func_sec_offset = (current_imm + 1) * 8;
                long func_addr = section_start + (long)func_sec_offset;
                int offset = (int)((func_addr - instr_next) / 8L);
                memory.setInt(relocationAddress.add(4L), offset);
                break;
            }
            default: {
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

