/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.lzfse;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.lzfse.LzfseFileSystem;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeBytesOnly;
import ghidra.framework.Application;
import ghidra.framework.OperatingSystem;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class LzfseFileSystemFactory
implements GFileSystemFactoryByteProvider<LzfseFileSystem>,
GFileSystemProbeBytesOnly {
    private static final int START_BYTES_REQUIRED = 4;
    private static final String LZFSE_NATIVE_BINARY_NAME = "lzfse";
    private static final String LZFSE_TEMP_PREFIX = "lzfse";
    private static final int LZFSE_NATIVE_TIMEOUT_SECONDS = 10;
    private static final int LZFSE_ENDOFSTREAM_BLOCK_MAGIC = 611874402;
    private static final int LZFSE_UNCOMPRESSED_BLOCK_MAGIC = 762869346;
    private static final int LZFSE_COMPRESSEDV1_BLOCK_MAGIC = 829978210;
    private static final int LZFSE_COMPRESSEDV2_BLOCK_MAGIC = 846755426;
    private static final int LZFSE_COMPRESSEDLZVN_BLOCK_MAGIC = 1853388386;

    public int getBytesRequired() {
        return 4;
    }

    public boolean probeStartBytes(FSRL containerFSRL, byte[] startBytes) {
        int startValue = ByteBuffer.wrap(startBytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
        return switch (startValue) {
            case 611874402, 762869346, 829978210, 846755426, 1853388386 -> true;
            default -> false;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GFileSystem create(FSRLRoot targetFSRL, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        File compressedFile = null;
        File decompressedFile = null;
        try {
            compressedFile = fsService.createPlaintextTempFile(byteProvider, "lzfse", monitor);
            decompressedFile = this.lzfseDecompress(compressedFile);
            LzfseFileSystem lzfseFileSystem = new LzfseFileSystem(targetFSRL, decompressedFile, fsService, monitor);
            return lzfseFileSystem;
        }
        finally {
            byteProvider.close();
            if (compressedFile != null && compressedFile.exists()) {
                compressedFile.delete();
            }
            if (decompressedFile != null && decompressedFile.exists()) {
                decompressedFile.delete();
            }
        }
    }

    private File lzfseDecompress(File compressedFile) throws IOException {
        Object lzfseName = "lzfse";
        if (OperatingSystem.CURRENT_OPERATING_SYSTEM.equals((Object)OperatingSystem.WINDOWS)) {
            lzfseName = (String)lzfseName + ".exe";
        }
        File lzfseNativeBinary = Application.getOSFile((String)lzfseName);
        File decompressedFile = Application.createTempFile((String)"lzfse", (String)Long.toString(System.currentTimeMillis()));
        ArrayList<String> command = new ArrayList<String>();
        command.add(lzfseNativeBinary.getPath());
        command.add("-decode");
        command.add("-i");
        command.add(compressedFile.getPath());
        command.add("-o");
        command.add(decompressedFile.getPath());
        Process p = new ProcessBuilder(command).start();
        boolean success = false;
        try {
            if (!p.waitFor(10L, TimeUnit.SECONDS)) {
                p.destroyForcibly();
                throw new IOException("lzfse native decompressor timed out");
            }
            if (p.exitValue() != 0) {
                throw new IOException("lzfse native decompressor failed with exit code: " + p.exitValue());
            }
            success = true;
            File file = decompressedFile;
            return file;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            if (!success) {
                decompressedFile.delete();
            }
        }
    }
}

