/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.filters;

import ghidra.feature.vt.gui.filters.AncillaryFilter;
import ghidra.feature.vt.gui.filters.CheckBoxInfo;
import ghidra.feature.vt.gui.filters.Filter;
import ghidra.feature.vt.gui.filters.FilterState;
import ghidra.framework.options.SaveState;
import ghidra.util.layout.ColumnLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class CheckBoxBasedAncillaryFilter<T>
extends AncillaryFilter<T> {
    private JComponent component;
    protected Set<CheckBoxInfo<T>> checkBoxInfos = new TreeSet<CheckBoxInfo<T>>(new CheckBoxInfoComparator(this));
    private Set<String> enabledCheckBoxNames;
    private final String filterName;

    public CheckBoxBasedAncillaryFilter(String filterName) {
        this.filterName = filterName;
        this.createCheckBoxInfos();
        this.component = this.createComponent();
    }

    protected abstract void createCheckBoxInfos();

    @Override
    public void fireFilterStateChanged() {
        this.enabledCheckBoxNames = null;
        super.fireFilterStateChanged();
    }

    private Set<String> initializeEnabledCheckBoxNames() {
        if (this.enabledCheckBoxNames == null) {
            this.enabledCheckBoxNames = this.checkBoxInfos.stream().filter(info -> info.isSelected()).map(info -> info.getCheckBox().getText()).collect(Collectors.toSet());
        }
        return this.enabledCheckBoxNames;
    }

    public Set<String> getEnabledFilterNames() {
        return this.initializeEnabledCheckBoxNames();
    }

    protected JComponent createComponent() {
        LayoutManager manager = this.createLayoutManager();
        JPanel panel = new JPanel();
        panel.setLayout(manager);
        panel.setBorder(BorderFactory.createTitledBorder(this.filterName));
        this.addCheckBoxes(panel);
        return this.createFilterPanel(panel);
    }

    protected JPanel createFilterPanel(JPanel checkBoxPanel) {
        return checkBoxPanel;
    }

    private LayoutManager createLayoutManager() {
        int maxColumnThreshold = 7;
        VerticalLayout manager = this.checkBoxInfos.size() <= maxColumnThreshold ? new VerticalLayout(1) : new ColumnLayout(1, 1, 2);
        return manager;
    }

    private void addCheckBoxes(Container container) {
        for (CheckBoxInfo<T> info : this.checkBoxInfos) {
            container.add(info.getCheckBox());
        }
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public Filter.FilterEditingStatus getFilterStatus() {
        for (CheckBoxInfo<T> info : this.checkBoxInfos) {
            if (info.isSelected()) continue;
            return Filter.FilterEditingStatus.APPLIED;
        }
        return Filter.FilterEditingStatus.NONE;
    }

    @Override
    public boolean passesFilter(T t) {
        for (CheckBoxInfo<T> info : this.checkBoxInfos) {
            if (!info.matchesStatus(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Filter.FilterShortcutState getFilterShortcutState() {
        int onCount = 0;
        for (CheckBoxInfo<T> info : this.checkBoxInfos) {
            if (!info.isSelected()) continue;
            ++onCount;
        }
        if (onCount == 0) {
            return Filter.FilterShortcutState.NEVER_PASSES;
        }
        if (onCount == this.checkBoxInfos.size()) {
            return Filter.FilterShortcutState.ALWAYS_PASSES;
        }
        return Filter.FilterShortcutState.REQUIRES_CHECK;
    }

    @Override
    public FilterState getFilterState() {
        FilterState state = new FilterState(this);
        for (CheckBoxInfo<T> info : this.checkBoxInfos) {
            JCheckBox checkBox = info.getCheckBox();
            state.put(checkBox.getText(), checkBox.isSelected());
        }
        return state;
    }

    @Override
    public void restoreFilterState(FilterState state) {
        for (CheckBoxInfo<T> info : this.checkBoxInfos) {
            JCheckBox checkBox = info.getCheckBox();
            checkBox.setSelected((Boolean)state.get(checkBox.getText()));
        }
    }

    @Override
    public void readConfigState(SaveState saveState) {
        String[] values = saveState.getStrings(this.getStateKey(), null);
        if (values == null) {
            return;
        }
        Map<String, CheckBoxInfo<T>> nameToInfoMap = this.createNameToInfoMap();
        for (String value : values) {
            String[] nameAndState = value.split(":");
            String name = nameAndState[0];
            CheckBoxInfo<T> info = nameToInfoMap.get(name);
            if (info == null) continue;
            String state = nameAndState[1];
            JCheckBox checkBox = info.getCheckBox();
            checkBox.setSelected(Boolean.parseBoolean(state));
        }
    }

    private Map<String, CheckBoxInfo<T>> createNameToInfoMap() {
        HashMap<String, CheckBoxInfo<T>> map = new HashMap<String, CheckBoxInfo<T>>();
        for (CheckBoxInfo<T> info : this.checkBoxInfos) {
            map.put(info.getCheckBox().getText(), info);
        }
        return map;
    }

    @Override
    public void writeConfigState(SaveState saveState) {
        String[] values = new String[this.checkBoxInfos.size()];
        int i = 0;
        for (CheckBoxInfo<T> info : this.checkBoxInfos) {
            JCheckBox checkBox = info.getCheckBox();
            String text = checkBox.getText();
            values[i++] = text + ":" + Boolean.toString(checkBox.isSelected());
        }
        String key = this.getStateKey();
        saveState.putStrings(key, values);
    }

    private String getStateKey() {
        return CheckBoxBasedAncillaryFilter.class.getSimpleName() + ":" + this.getClass().getName();
    }

    @Override
    public boolean isSubFilterOf(Filter<T> otherFilter) {
        Class<?> otherClazz;
        Class<?> clazz = this.getClass();
        if (!clazz.equals(otherClazz = otherFilter.getClass())) {
            return false;
        }
        CheckBoxBasedAncillaryFilter otherCheckboxFilter = (CheckBoxBasedAncillaryFilter)otherFilter;
        Set<String> names = this.getEnabledFilterNames();
        Set<String> otherNames = otherCheckboxFilter.getEnabledFilterNames();
        return otherNames.containsAll(names);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + String.valueOf(this.getEnabledFilterNames());
    }

    private class CheckBoxInfoComparator
    implements Comparator<CheckBoxInfo<T>> {
        private CheckBoxInfoComparator(CheckBoxBasedAncillaryFilter checkBoxBasedAncillaryFilter) {
        }

        @Override
        public int compare(CheckBoxInfo<T> o1, CheckBoxInfo<T> o2) {
            JCheckBox checkBox1 = o1.getCheckBox();
            JCheckBox checkBox2 = o2.getCheckBox();
            String text1 = checkBox1.getText();
            String text2 = checkBox2.getText();
            return text1.compareToIgnoreCase(text2);
        }
    }
}

