/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser.filehandlers;

import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import ghidra.framework.model.DomainFile;
import ghidra.plugin.importer.ProjectIndexService;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBComponentProvider;
import ghidra.plugins.fsbrowser.FSBFileHandler;
import ghidra.plugins.fsbrowser.FSBFileHandlerContext;
import ghidra.plugins.fsbrowser.FileSystemBrowserPlugin;
import ghidra.plugins.fsbrowser.OpenWithTarget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OpenWithFSBFileHandler
implements FSBFileHandler {
    private FSBFileHandlerContext context;

    @Override
    public void init(FSBFileHandlerContext context) {
        this.context = context;
    }

    @Override
    public List<DockingAction> getPopupProviderActions() {
        FileSystemBrowserPlugin plugin = this.context.plugin();
        ArrayList<DockingAction> results = new ArrayList<DockingAction>();
        for (OpenWithTarget target : OpenWithTarget.getAll()) {
            DockingAction action = (DockingAction)new ActionBuilder("FSB Open With " + target.getName(), plugin.getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.hasSelectedLinkedNodes()).popupMenuIcon(target.getIcon()).popupMenuPath(new String[]{"Open With", target.getName()}).popupMenuGroup(target.getPm() != null ? "A" : "B").onAction(ac -> {
                FSBComponentProvider fsbComp = ac.getComponentProvider();
                ProjectIndexService projectIndex = fsbComp.getProjectIndex();
                List<DomainFile> filesToOpen = ac.getSelectedNodes().stream().map(node -> projectIndex.findFirstByFSRL(node.getFSRL())).filter(Objects::nonNull).toList();
                target.open(filesToOpen);
            }).build();
            action.getPopupMenuData().setParentMenuGroup("C");
            results.add(action);
        }
        return results;
    }
}

