/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigationUtils;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.app.services.GoToService;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.query.TableService;
import ghidra.app.util.viewer.field.FieldMouseHandlerExtension;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.MnemonicFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.table.IncomingReferencesTableModel;
import ghidra.util.table.field.OutgoingReferenceEndpoint;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class MnemonicFieldMouseHandler
implements FieldMouseHandlerExtension {
    private static final Class<?>[] SUPPORTED_CLASSES = new Class[]{MnemonicFieldLocation.class};

    @Override
    public boolean fieldElementClicked(Object clickedObject, Navigatable sourceNavigatable, ProgramLocation location, MouseEvent mouseEvent, ServiceProvider serviceProvider) {
        if (mouseEvent.getClickCount() != 2 || mouseEvent.getButton() != 1) {
            return false;
        }
        ProgramManager programManager = (ProgramManager)serviceProvider.getService(ProgramManager.class);
        if (programManager == null) {
            return false;
        }
        Program program = programManager.getCurrentProgram();
        Listing listing = program.getListing();
        CodeUnit codeUnit = listing.getCodeUnitAt(location.getAddress());
        return this.checkMemReferences(codeUnit, serviceProvider);
    }

    private boolean checkMemReferences(CodeUnit codeUnit, ServiceProvider serviceProvider) {
        if (codeUnit == null) {
            return false;
        }
        Reference[] refs = codeUnit.getMnemonicReferences();
        if (refs.length > 1) {
            ArrayList<OutgoingReferenceEndpoint> outgoingReferences = new ArrayList<OutgoingReferenceEndpoint>();
            for (Reference reference : refs) {
                outgoingReferences.add(new OutgoingReferenceEndpoint(reference, ReferenceUtils.isOffcut(codeUnit.getProgram(), reference.getToAddress())));
            }
            IncomingReferencesTableModel model = new IncomingReferencesTableModel("Mnemonic", serviceProvider, codeUnit.getProgram(), outgoingReferences, null);
            TableService service = (TableService)serviceProvider.getService(TableService.class);
            if (service != null) {
                Navigatable nav = NavigationUtils.getActiveNavigatable();
                service.showTable("Mnemonic References", "Mnemonic", model, "References", nav);
                return true;
            }
        } else if (refs.length == 1) {
            SymbolTable st = codeUnit.getProgram().getSymbolTable();
            Symbol symbol = st.getSymbol(refs[0]);
            Object loc = null;
            loc = symbol != null ? symbol.getProgramLocation() : new AddressFieldLocation(codeUnit.getProgram(), refs[0].getToAddress());
            GoToService goToService = (GoToService)serviceProvider.getService(GoToService.class);
            if (goToService != null) {
                return goToService.goTo((ProgramLocation)loc);
            }
        }
        return false;
    }

    @Override
    public Class<?>[] getSupportedProgramLocations() {
        return SUPPORTED_CLASSES;
    }
}

