/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pef;

import ghidra.app.cmd.label.AddUniqueLabelCmd;
import ghidra.app.util.bin.format.pef.ContainerHeader;
import ghidra.app.util.bin.format.pef.ImportedLibrary;
import ghidra.app.util.bin.format.pef.LoaderInfoHeader;
import ghidra.app.util.bin.format.pef.SectionHeader;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.AssertException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImportStateCache {
    private Program program;
    private SymbolTable symbolTable;
    private Namespace importNamespace;
    private Namespace tVectNamespace;
    private Map<ImportedLibrary, Namespace> libraryNamespaceMap = new HashMap<ImportedLibrary, Namespace>();
    private Map<ImportedLibrary, Map<String, Symbol>> librarySymbolsMap = new HashMap<ImportedLibrary, Map<String, Symbol>>();
    private Map<SectionHeader, MemoryBlock> sectionMap = new HashMap<SectionHeader, MemoryBlock>();
    private Address tocAddress;

    public ImportStateCache(Program program, ContainerHeader header) {
        this.program = program;
        this.symbolTable = program.getSymbolTable();
        this.importNamespace = this.createNamespace(null, ".import");
        this.tVectNamespace = this.createNamespace(null, ".TVect");
        LoaderInfoHeader loader = header.getLoader();
        List<ImportedLibrary> libraries = loader.getImportedLibraries();
        for (ImportedLibrary library : libraries) {
            String libraryName = SymbolUtilities.replaceInvalidChars((String)library.getName(), (boolean)true);
            Namespace libraryNamespace = this.createNamespace(this.importNamespace, libraryName);
            this.libraryNamespaceMap.put(library, libraryNamespace);
            this.librarySymbolsMap.put(library, new HashMap());
        }
    }

    public void dispose() {
        this.libraryNamespaceMap.clear();
        this.librarySymbolsMap.clear();
    }

    public Namespace getTVectNamespace() {
        return this.tVectNamespace;
    }

    public Namespace getNamespace(ImportedLibrary library) {
        return this.libraryNamespaceMap.get(library);
    }

    public MemoryBlock getMemoryBlockForSection(SectionHeader section) {
        return this.sectionMap.get(section);
    }

    public void setMemoryBlockForSection(SectionHeader section, MemoryBlock block) {
        if (this.sectionMap.containsKey(section)) {
            throw new AssertException();
        }
        this.sectionMap.put(section, block);
    }

    public Symbol getSymbol(String symbolName, ImportedLibrary library) {
        Map<String, Symbol> map = this.librarySymbolsMap.get(library);
        return map.get(symbolName);
    }

    public boolean createLibrarySymbol(ImportedLibrary library, String symbolName, Address address) {
        Namespace libraryNamespace = this.getNamespace(library);
        AddUniqueLabelCmd cmd = new AddUniqueLabelCmd(address, symbolName, libraryNamespace, SourceType.IMPORTED);
        boolean success = cmd.applyTo(this.program);
        Symbol symbol = cmd.getNewSymbol();
        Map<String, Symbol> map = this.librarySymbolsMap.get(library);
        map.put(symbolName, symbol);
        return success;
    }

    private Namespace createNamespace(Namespace parent, String name) {
        Namespace namespace = this.symbolTable.getNamespace(name, parent);
        if (namespace != null) {
            return namespace;
        }
        try {
            return this.program.getSymbolTable().createNameSpace(parent, name, SourceType.IMPORTED);
        }
        catch (Exception e) {
            return this.program.getGlobalNamespace();
        }
    }

    public Address getTocAddress() {
        return this.tocAddress;
    }

    public void setTocAddress(Address tocAddress) {
        this.tocAddress = tocAddress;
    }
}

