/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf51;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfString;
import ghidra.app.util.bin.format.omf.OmfUtils;
import java.io.IOException;

public class Omf51Segment {
    public static final int CODE = 0;
    public static final int XDATA = 1;
    public static final int DATA = 2;
    public static final int IDATA = 3;
    public static final int BIT = 4;
    public static final int ABS = 0;
    public static final int UNIT = 1;
    public static final int BITADDRESSABLE = 2;
    public static final int INPAGE = 3;
    public static final int INBLOCK = 4;
    public static final int PAGE = 5;
    private int id;
    private byte info;
    private byte relType;
    private int base;
    private int size;
    private OmfString name;

    public Omf51Segment(BinaryReader reader, boolean largeSegmentId) throws IOException {
        this.id = largeSegmentId ? reader.readNextUnsignedShort() : reader.readNextUnsignedByte();
        this.info = reader.readNextByte();
        this.relType = reader.readNextByte();
        reader.readNextByte();
        this.base = reader.readNextUnsignedShort();
        this.size = reader.readNextUnsignedShort();
        this.name = OmfUtils.readString(reader);
        if (this.size == 0) {
            this.size = 65536;
        }
        if ((this.info & 8) != 0) {
            this.size = 0;
        }
    }

    public int id() {
        return this.id;
    }

    public byte info() {
        return this.info;
    }

    public byte relType() {
        return this.relType;
    }

    public int base() {
        return this.base;
    }

    public int size() {
        return this.size;
    }

    public OmfString name() {
        return this.name;
    }

    public int getType() {
        return this.info & 7;
    }

    public boolean isCode() {
        return this.getType() == 0;
    }

    public boolean isAbsolute() {
        return this.id == 0;
    }
}

