/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf51;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfString;
import ghidra.app.util.bin.format.omf.OmfUtils;
import java.io.IOException;

public class Omf51PublicDef {
    public static final int CODE = 0;
    public static final int XDATA = 1;
    public static final int DATA = 2;
    public static final int IDATA = 3;
    public static final int BIT = 4;
    public static final int NUMBER = 5;
    public static final int REG_BANK_0 = 0;
    public static final int REG_BANK_1 = 1;
    public static final int REG_BANK_2 = 2;
    public static final int REG_BANK_3 = 3;
    private int segId;
    private byte info;
    private int offset;
    private OmfString name;

    public Omf51PublicDef(BinaryReader reader, boolean largeSegmentId) throws IOException {
        this.segId = largeSegmentId ? reader.readNextUnsignedShort() : reader.readNextUnsignedByte();
        this.info = reader.readNextByte();
        this.offset = reader.readNextUnsignedShort();
        reader.readNextByte();
        this.name = OmfUtils.readString(reader);
    }

    public int getSegId() {
        return this.segId;
    }

    public byte getInfo() {
        return this.info;
    }

    public int getOffset() {
        return this.offset;
    }

    public OmfString getName() {
        return this.name;
    }

    public int getUsageType() {
        return this.info & 7;
    }

    public boolean isVariable() {
        return (this.info & 0x40) != 0;
    }

    public boolean isIndirectlyCallable() {
        return (this.info & 0x80) != 0;
    }

    public boolean isFixedReg() {
        return (this.info & 0x20) != 0;
    }

    public int getRegBank() {
        return (this.info & 0x18) >> 7;
    }
}

