/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.info;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.elf.info.ElfNote;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import java.io.IOException;

public class NoteAbiTag
extends ElfNote {
    private static final int MIN_ABI_TAB_LEN = 16;
    public static final String SECTION_NAME = ".note.ABI-tag";
    private final int abiType;
    private final int[] requiredKernelVersion;

    public static NoteAbiTag read(ElfNote note, Program program) throws IOException {
        byte[] desc = note.getDescription();
        if (!note.isGnu() || desc.length < 16) {
            throw new IOException("Invalid .note.ABI-tag values: %s, %d".formatted(note.getName(), desc.length));
        }
        BinaryReader descReader = note.getDescriptionReader(!program.getMemory().isBigEndian());
        int abiType = descReader.readNextInt();
        int[] requiredKernelVersion = descReader.readNextIntArray(3);
        return new NoteAbiTag(note.getNameLen(), note.getName(), note.getVendorType(), abiType, requiredKernelVersion);
    }

    public static NoteAbiTag fromProgram(Program program) {
        return ElfNote.readFromProgramHelper(program, SECTION_NAME, NoteAbiTag::read);
    }

    public NoteAbiTag(int nameLen, String name, int vendorType, int abiType, int[] requiredKernelVersion) {
        super(nameLen, name, vendorType);
        this.abiType = abiType;
        this.requiredKernelVersion = requiredKernelVersion;
    }

    public int getAbiType() {
        return this.abiType;
    }

    public String getAbiTypeString() {
        return switch (this.abiType) {
            case 0 -> "Linux";
            default -> "Unknown(%d)".formatted(this.abiType);
        };
    }

    public String getRequiredKernelVersion() {
        return "%s %d.%d.%d".formatted(this.getAbiTypeString(), this.requiredKernelVersion[0], this.requiredKernelVersion[1], this.requiredKernelVersion[2]);
    }

    @Override
    public String getNoteValueString() {
        return this.getRequiredKernelVersion();
    }

    @Override
    public String getNoteTypeName() {
        return "required kernel ABI";
    }

    @Override
    public StructureDataType toStructure(DataTypeManager dtm) {
        StructureDataType result = NoteAbiTag.createNoteStructure(null, "NoteAbiTag", false, this.getNameLen(), 0, dtm);
        result.add(StructConverter.DWORD, "abiType", "0 == Linux");
        result.add((DataType)new ArrayDataType(StructConverter.DWORD, 3, -1, dtm), "requiredKernelVersion", "Major.minor.patch");
        return result;
    }
}

