/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string;

import generic.jar.ResourceFile;
import ghidra.app.plugin.core.string.ModelLogProbabilities;
import ghidra.app.plugin.core.string.StringAndScores;
import ghidra.app.plugin.core.string.StringModel;
import ghidra.framework.Application;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;

public class NGramUtils {
    private static final int ASCII_CHAR_COUNT = 128;
    private static ModelLogProbabilities logProbs = null;
    private static String lastLoadedTrigramModel = "";
    private static String lastLoadedTrigramModelPath = "";
    private static boolean initializationsDone = false;
    private static final String MODEL_FILE_EXTENSION = "sng";
    private static final String MODEL_TYPE_PREFIX = "Model Type: ";
    private static String modelType = "";
    private static double defaultLogValue = -20.0;
    private static int minimumStringLength = 3;
    private static final Double[] NG_THRESHOLDS = new Double[]{10.0, 10.0, 10.0, 10.0, -2.71, -3.26, -3.52, -3.84, -4.23, -4.49, -4.55, -4.74, -4.88, -5.03, -5.06, -5.2, -5.24, -5.29, -5.29, -5.42, -5.51, -5.52, -5.53, -5.6, -5.6, -5.62, -5.7, -5.7, -5.78, -5.79, -5.81, -5.81, -5.84, -5.85, -5.86, -5.88, -5.92, -5.92, -5.93, -5.95, -5.99, -6.0, -6.0, -6.0, -6.02, -6.02, -6.02, -6.05, -6.06, -6.07, -6.08, -6.1, -6.12, -6.12, -6.13, -6.13, -6.13, -6.13, -6.13, -6.13, -6.13, -6.15, -6.15, -6.16, -6.16, -6.16, -6.17, -6.19, -6.19, -6.21, -6.21, -6.21, -6.21, -6.21, -6.21, -6.25, -6.25, -6.25, -6.25, -6.25, -6.25, -6.25, -6.26, -6.26, -6.26, -6.26, -6.26, -6.26, -6.26, -6.26, -6.26, -6.29, -6.29, -6.3, -6.3, -6.3, -6.3, -6.3, -6.3, -6.3, -6.3};
    private static final double MAX_NG_THRESHOLD = -6.3;
    private static HashMap<String, Integer> descriptionToAsciiInt;

    private static void assignDescriptionsToASCIINums() {
        descriptionToAsciiInt = new HashMap();
        descriptionToAsciiInt.put("[NUL]", 0);
        descriptionToAsciiInt.put("[SOH]", 1);
        descriptionToAsciiInt.put("[STX]", 2);
        descriptionToAsciiInt.put("[ETX]", 3);
        descriptionToAsciiInt.put("[EOT]", 4);
        descriptionToAsciiInt.put("[ENQ]", 5);
        descriptionToAsciiInt.put("[ACK]", 6);
        descriptionToAsciiInt.put("[BEL]", 7);
        descriptionToAsciiInt.put("[BS]", 8);
        descriptionToAsciiInt.put("[HT]", 9);
        descriptionToAsciiInt.put("[LF]", 10);
        descriptionToAsciiInt.put("[VT]", 11);
        descriptionToAsciiInt.put("[FF]", 12);
        descriptionToAsciiInt.put("[CR]", 13);
        descriptionToAsciiInt.put("[SO]", 14);
        descriptionToAsciiInt.put("[SI]", 15);
        descriptionToAsciiInt.put("[DLE]", 16);
        descriptionToAsciiInt.put("[DC1]", 17);
        descriptionToAsciiInt.put("[DC2]", 18);
        descriptionToAsciiInt.put("[DC3]", 19);
        descriptionToAsciiInt.put("[DC4]", 20);
        descriptionToAsciiInt.put("[NAK]", 21);
        descriptionToAsciiInt.put("[SYN]", 22);
        descriptionToAsciiInt.put("[ETB]", 23);
        descriptionToAsciiInt.put("[CAN]", 24);
        descriptionToAsciiInt.put("[EM]", 25);
        descriptionToAsciiInt.put("[SUB]", 26);
        descriptionToAsciiInt.put("[ESC]", 27);
        descriptionToAsciiInt.put("[FS]", 28);
        descriptionToAsciiInt.put("[GS]", 29);
        descriptionToAsciiInt.put("[RS]", 30);
        descriptionToAsciiInt.put("[US]", 31);
        descriptionToAsciiInt.put("[SP]", 32);
        descriptionToAsciiInt.put("[DEL]", 127);
    }

    public static void startNewSession(String trigramFile, boolean forceReload) throws IOException {
        if (!initializationsDone) {
            for (int i = 0; i < NG_THRESHOLDS.length; ++i) {
                if (!(NG_THRESHOLDS[i] < 0.0)) continue;
                minimumStringLength = i;
                break;
            }
            NGramUtils.assignDescriptionsToASCIINums();
            initializationsDone = true;
        }
        if (forceReload || !lastLoadedTrigramModel.equals(trigramFile)) {
            logProbs = new ModelLogProbabilities(128);
            NGramUtils.loadStringModels(trigramFile);
        }
    }

    public static void startNewSession(StringModel model) {
        logProbs = new ModelLogProbabilities(128);
        NGramUtils.loadStringModels(model);
    }

    public static void startNewSession(File model) throws IOException {
        logProbs = new ModelLogProbabilities(128);
        NGramUtils.loadStringModels(new FileInputStream(model), model.getName());
    }

    private static void loadStringModels(String trigramFile) throws IOException {
        List modelFiles = Application.findFilesByExtensionInApplication((String)MODEL_FILE_EXTENSION);
        InputStream countFileContents = null;
        String filename = "";
        ResourceFile foundFile = null;
        for (ResourceFile resourceFile : modelFiles) {
            filename = resourceFile.getName();
            if (!filename.equals(trigramFile)) continue;
            countFileContents = resourceFile.isFile() ? resourceFile.getInputStream() : null;
            foundFile = resourceFile;
            break;
        }
        if (countFileContents == null) {
            lastLoadedTrigramModelPath = "";
            lastLoadedTrigramModel = "";
            throw new IOException("Was not able to load the strings model file (" + trigramFile + ")");
        }
        NGramUtils.loadStringModels(countFileContents, filename);
        lastLoadedTrigramModelPath = foundFile.getAbsolutePath();
    }

    private static void loadStringModels(InputStream trigramFileStream, String filename) throws IOException {
        NGramUtils.ingestModel(trigramFileStream, filename);
        lastLoadedTrigramModel = filename;
    }

    private static void loadStringModels(StringModel model) {
        int i;
        int[][] tempDoubleArr = model.getBeginTrigramCounts();
        int copyLength = tempDoubleArr.length;
        int[][] beginTrigramCounts = new int[copyLength][];
        for (i = 0; i < copyLength; ++i) {
            beginTrigramCounts[i] = Arrays.copyOf(tempDoubleArr[i], tempDoubleArr[i].length);
        }
        tempDoubleArr = model.getEndTrigramCounts();
        copyLength = tempDoubleArr.length;
        int[][] endTrigramCounts = new int[copyLength][];
        for (i = 0; i < copyLength; ++i) {
            endTrigramCounts[i] = Arrays.copyOf(tempDoubleArr[i], tempDoubleArr[i].length);
        }
        int[][][] tempTripleArr = model.getTrigramCounts();
        copyLength = tempTripleArr.length;
        int[][][] trigramCounts = new int[copyLength][][];
        for (int i2 = 0; i2 < copyLength; ++i2) {
            tempDoubleArr = tempTripleArr[i2];
            trigramCounts[i2] = new int[tempDoubleArr.length][];
            for (int j = 0; j < tempDoubleArr.length; ++j) {
                trigramCounts[i2][j] = Arrays.copyOf(tempDoubleArr[j], tempDoubleArr[j].length);
            }
        }
        long totalTrigrams = model.getTotalNumTrigrams();
        NGramUtils.smoothCountsAndCalculateLogProbs(beginTrigramCounts, endTrigramCounts, trigramCounts, totalTrigrams);
        lastLoadedTrigramModel = "";
    }

    private static void ingestModel(InputStream modelStream, String modelName) throws IOException {
        Scanner scanner1 = new Scanner(modelStream, "UTF-8");
        String currString = "";
        int[][] beginTrigramCounts = new int[128][128];
        int[][] endTrigramCounts = new int[128][128];
        int[][][] trigramCounts = new int[128][128][128];
        long totalTrigrams = 0L;
        try {
            while (scanner1.hasNextLine()) {
                currString = scanner1.nextLine();
                if (currString.startsWith("#")) {
                    if (!currString.contains(MODEL_TYPE_PREFIX)) continue;
                    modelType = currString.substring(MODEL_TYPE_PREFIX.length() + 2);
                    continue;
                }
                if (currString.trim().length() <= 0) continue;
                String[] charInfo = currString.split("\\t");
                if (charInfo.length != 4) {
                    throw new IOException("In model file " + modelName + ", this line should split into 4 parts: " + currString);
                }
                int currCount = Integer.parseInt(charInfo[3]);
                if ((charInfo = NGramUtils.convertToAsciiNums(charInfo))[0].equals("[^]")) {
                    if (!charInfo[2].equals("[$]")) {
                        int[] nArray = beginTrigramCounts[Integer.parseInt(charInfo[1])];
                        int n = Integer.parseInt(charInfo[2]);
                        nArray[n] = nArray[n] + currCount;
                    }
                } else if (charInfo[2].equals("[$]")) {
                    int[] nArray = endTrigramCounts[Integer.parseInt(charInfo[0])];
                    int n = Integer.parseInt(charInfo[1]);
                    nArray[n] = nArray[n] + currCount;
                } else {
                    int[] nArray = trigramCounts[Integer.parseInt(charInfo[0])][Integer.parseInt(charInfo[1])];
                    int n = Integer.parseInt(charInfo[2]);
                    nArray[n] = nArray[n] + currCount;
                }
                totalTrigrams += (long)currCount;
            }
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Can not parse line: " + currString + " in model file '" + modelName + "'");
        }
        finally {
            scanner1.close();
        }
        if (modelType.equals("")) {
            throw new IOException("Model file: " + modelName + " does not contain the model type.");
        }
        NGramUtils.smoothCountsAndCalculateLogProbs(beginTrigramCounts, endTrigramCounts, trigramCounts, totalTrigrams);
    }

    private static String[] convertToAsciiNums(String[] inputChars) throws NumberFormatException, IOException {
        String[] retArr = new String[inputChars.length];
        for (int i = 0; i < retArr.length - 1; ++i) {
            if (inputChars[i].length() > 1) {
                if (descriptionToAsciiInt.containsKey(inputChars[i])) {
                    retArr[i] = descriptionToAsciiInt.get(inputChars[i]).toString();
                    continue;
                }
                if (inputChars[i].equals("[^]") || inputChars[i].equals("[$]")) {
                    retArr[i] = inputChars[i];
                    continue;
                }
                throw new IOException("Can not parse character " + inputChars[i] + " in model file (expecting a string representation of an ASCII character).");
            }
            retArr[i] = Integer.valueOf(Character.valueOf(inputChars[i].charAt(0)).charValue()).toString();
        }
        return retArr;
    }

    private static void smoothCountsAndCalculateLogProbs(int[][] beginTrigramCounts, int[][] endTrigramCounts, int[][][] trigramCounts, long totalTrigrams) {
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 128; ++j) {
                if (beginTrigramCounts[i][j] == 0) {
                    beginTrigramCounts[i][j] = 1;
                    ++totalTrigrams;
                }
                if (endTrigramCounts[i][j] == 0) {
                    endTrigramCounts[i][j] = 1;
                    ++totalTrigrams;
                }
                for (int k = 0; k < 128; ++k) {
                    if (trigramCounts[i][j][k] != 0) continue;
                    trigramCounts[i][j][k] = 1;
                    ++totalTrigrams;
                }
            }
        }
        double[][] beginLogTrigrams = logProbs.getBeginLogTrigrams();
        double[][] endLogTrigrams = logProbs.getEndLogTrigrams();
        double[][][] logTrigrams = logProbs.getLogTrigrams();
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 128; ++j) {
                beginLogTrigrams[i][j] = Math.log10((double)beginTrigramCounts[i][j] / (double)totalTrigrams);
                endLogTrigrams[i][j] = Math.log10((double)endTrigramCounts[i][j] / (double)totalTrigrams);
                for (int k = 0; k < 128; ++k) {
                    logTrigrams[i][j][k] = Math.log10((double)trigramCounts[i][j][k] / (double)totalTrigrams);
                }
            }
        }
    }

    public static void scoreString(StringAndScores strAndScores) {
        int[] asciiCodes = strAndScores.getAsciiCodes();
        double ngScore = asciiCodes.length < 3 ? defaultLogValue : NGramUtils.calculateTrigrams(asciiCodes);
        strAndScores.setNgramScore(ngScore);
        int strLen = strAndScores.getScoredStringLength();
        double thresholdToUse = strLen >= NG_THRESHOLDS.length ? -6.3 : NG_THRESHOLDS[strLen];
        strAndScores.setScoreThreshold(thresholdToUse);
    }

    public static void scoreStrings(List<StringAndScores> strAndScoresList) {
        for (StringAndScores sas : strAndScoresList) {
            NGramUtils.scoreString(sas);
        }
    }

    public static int getMinimumStringLength() {
        return minimumStringLength;
    }

    private static double calculateTrigrams(int[] asciiCodes) {
        int charIndex;
        int stringLength = asciiCodes.length;
        int maxIndNgram = stringLength - 3;
        double localLikelihood = 0.0;
        double[][] beginTrigramProbs = logProbs.getBeginLogTrigrams();
        double[][] endTrigramProbs = logProbs.getEndLogTrigrams();
        double[][][] trigramProbs = logProbs.getLogTrigrams();
        if (stringLength < 3) {
            return defaultLogValue;
        }
        localLikelihood += beginTrigramProbs[asciiCodes[0]][asciiCodes[1]];
        for (charIndex = 1; charIndex <= maxIndNgram; ++charIndex) {
            localLikelihood += trigramProbs[asciiCodes[charIndex]][asciiCodes[charIndex + 1]][asciiCodes[charIndex + 2]];
        }
        return (localLikelihood += endTrigramProbs[asciiCodes[charIndex]][asciiCodes[charIndex + 1]]) / (double)stringLength;
    }

    public static String getModelType() {
        return modelType;
    }

    public static boolean isLowerCaseModel() {
        return modelType.equalsIgnoreCase("lowercase");
    }

    public static String getLastLoadedTrigramModel() {
        return lastLoadedTrigramModel;
    }

    public static String getLastLoadedTrigramModelPath() {
        return lastLoadedTrigramModelPath;
    }
}

